/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.site.xmlsitemap.CmsXmlSeoConfiguration;
import org.opencms.site.xmlsitemap.CmsXmlSitemapActionElement;
import org.opencms.site.xmlsitemap.CmsXmlSitemapCache;
import org.opencms.site.xmlsitemap.CmsXmlSitemapGenerator;

public class CmsUpdateXmlSitemapCacheJob
implements I_CmsScheduledJob {
    private static final Log LOG = CmsLog.getLog(CmsUpdateXmlSitemapCacheJob.class);

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        long start = System.currentTimeMillis();
        LOG.info((Object)("Starting job " + this.getClass().getName()));
        String parentFolder = parameters.get("folder");
        if (parentFolder == null) {
            parentFolder = "/";
        }
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType("seo_file");
        List<CmsResource> resources = cms.readResources(parentFolder, CmsResourceFilter.DEFAULT_FILES.addRequireType(type));
        LOG.info((Object)"Starting to process individual XML sitemap files...");
        int i = 0;
        for (CmsResource res : resources) {
            ++i;
            try {
                LOG.info((Object)("Processing file " + res.getRootPath() + " [" + i + "/" + resources.size() + "]"));
                String name = res.getName();
                if (name.contains("robots") || name.contains("test")) {
                    LOG.info((Object)("Ignoring file " + res.getRootPath()));
                    continue;
                }
                CmsXmlSeoConfiguration config = new CmsXmlSeoConfiguration();
                config.load(cms, res);
                CmsXmlSitemapGenerator generator = null;
                if (config.usesCache()) {
                    generator = CmsXmlSitemapActionElement.prepareSitemapGenerator(res, config);
                }
                if (generator != null) {
                    String xml = generator.renderSitemap();
                    CmsXmlSitemapCache.INSTANCE.put(res.getRootPath(), xml);
                    continue;
                }
                LOG.info((Object)("Ignoring file " + res.getRootPath()));
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing file " + res.getRootPath() + ": " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        LOG.info((Object)("Finished processing XML sitemap files. Elapsed time: " + (end - start) / 1000L + " seconds"));
        return "";
    }
}

