/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public final class CmsSiteMatcher
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3988887650237005342L;
    private static final Log LOG = CmsLog.getLog(CmsSiteMatcher.class);
    private static final int PORT_HTTP = 80;
    private static final int PORT_HTTPS = 443;
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String WILDCARD = "*";
    public static final CmsSiteMatcher DEFAULT_MATCHER = new CmsSiteMatcher("*", "*", 0);
    private transient Integer m_hashCode;
    private String m_serverName;
    private int m_serverPort;
    private String m_serverProtocol;
    private long m_timeOffset;
    private RedirectMode m_redirect = RedirectMode.none;

    public CmsSiteMatcher(String serverString) {
        this(serverString, 0L);
    }

    public CmsSiteMatcher(String serverString, long timeOffset) {
        if (serverString == null) {
            this.init(WILDCARD, WILDCARD, 0, timeOffset);
            return;
        }
        try {
            int serverPort;
            String serverProtocol;
            URI uri = new URI(serverString);
            if (uri.getScheme() != null) {
                serverProtocol = uri.getScheme();
            } else {
                serverProtocol = SCHEME_HTTP;
                uri = new URI(serverProtocol + "://" + serverString);
            }
            String serverName = uri.getHost();
            if (serverName == null) {
                LOG.error((Object)("Invalid server name: " + serverString));
                String authority = uri.getAuthority();
                String candidate = authority.replaceFirst(":[0-9]+$", "");
                int atIndex = candidate.indexOf("@");
                if (atIndex != -1) {
                    candidate = candidate.substring(atIndex + 1);
                }
                serverName = candidate;
            }
            if ((serverPort = uri.getPort()) == -1) {
                serverPort = SCHEME_HTTPS.equals(serverProtocol) ? 443 : 80;
            }
            this.init(serverProtocol, serverName, serverPort, timeOffset);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Invalid server name: " + serverString), (Throwable)e);
            this.init(WILDCARD, WILDCARD, 0, timeOffset);
        }
    }

    public CmsSiteMatcher(String serverProtocol, String serverName, int serverPort) {
        this.init(serverProtocol, serverName, serverPort, 0L);
    }

    public CmsSiteMatcher(String serverProtocol, String serverName, int serverPort, long timeOffset) {
        this.init(serverProtocol, serverName, serverPort, timeOffset);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CmsSiteMatcher)) {
            return false;
        }
        if (this == DEFAULT_MATCHER || obj == DEFAULT_MATCHER) {
            return true;
        }
        CmsSiteMatcher other = (CmsSiteMatcher)obj;
        return this.m_serverPort == other.m_serverPort && this.m_serverName.equalsIgnoreCase(other.m_serverName) && this.m_serverProtocol.equals(other.m_serverProtocol);
    }

    public boolean equalsIgnoreScheme(CmsSiteMatcher matcher) {
        for (String scheme : Arrays.asList(SCHEME_HTTP, SCHEME_HTTPS)) {
            if (!this.forDifferentScheme(scheme).equals(matcher)) continue;
            return true;
        }
        return false;
    }

    public CmsSiteMatcher forDifferentScheme(String scheme) {
        try {
            URI uri = new URI(this.getUrl());
            URI changedUri = new URI(scheme, uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            CmsSiteMatcher res = new CmsSiteMatcher(changedUri.toString(), this.m_timeOffset);
            res.m_redirect = this.m_redirect;
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public RedirectMode getRedirectMode() {
        return this.m_redirect;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public int getServerPort() {
        return this.m_serverPort;
    }

    public String getServerProtocol() {
        return this.m_serverProtocol;
    }

    public long getTimeOffset() {
        return this.m_timeOffset;
    }

    public String getUrl() {
        return this.m_serverProtocol + "://" + this.m_serverName + (String)(this.m_serverPort != 80 && this.m_serverPort != 443 ? ":" + this.m_serverPort : "");
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            this.m_hashCode = this.toString().hashCode();
        }
        return this.m_hashCode;
    }

    public boolean isRedirect() {
        return this.m_redirect != RedirectMode.none;
    }

    public void setRedirectMode(RedirectMode redirect) {
        this.m_redirect = redirect;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        if (this.m_serverProtocol != null && !WILDCARD.equals(this.m_serverProtocol)) {
            result.append(this.m_serverProtocol);
            result.append("://");
        }
        result.append(this.m_serverName);
        if (!(this.m_serverPort <= 0 || SCHEME_HTTP.equals(this.m_serverProtocol) && this.m_serverPort == 80 || SCHEME_HTTPS.equals(this.m_serverProtocol) && this.m_serverPort == 443)) {
            result.append(":");
            result.append(this.m_serverPort);
        }
        return result.toString();
    }

    protected void setServerName(String serverName) {
        this.m_serverName = CmsStringUtil.isEmpty(serverName) || WILDCARD.equals(serverName) ? WILDCARD : serverName.trim();
    }

    protected void setServerPort(int serverPort) {
        this.m_serverPort = serverPort;
        if (this.m_serverPort < 0) {
            this.m_serverPort = 0;
        }
    }

    protected void setServerProtocol(String serverProtocol) {
        int pos;
        this.m_serverProtocol = CmsStringUtil.isEmpty(serverProtocol) || WILDCARD.equals(serverProtocol) ? WILDCARD : ((pos = serverProtocol.indexOf("/")) > 0 ? serverProtocol.substring(0, pos).toLowerCase() : serverProtocol.toLowerCase().trim());
    }

    protected void setTimeOffset(long timeOffset) {
        this.m_timeOffset = timeOffset * 1000L;
    }

    private void init(String serverProtocol, String serverName, int serverPort, long timeOffset) {
        this.setServerProtocol(serverProtocol);
        this.setServerName(serverName);
        this.setServerPort(serverPort);
        this.setTimeOffset(timeOffset);
    }

    public static enum RedirectMode {
        none,
        temporary,
        permanent;


        public static RedirectMode parse(String strValue) {
            if (strValue == null) {
                return none;
            }
            if ("true".equals(strValue = strValue.toLowerCase())) {
                return temporary;
            }
            if ("permanent".equals(strValue)) {
                return permanent;
            }
            return none;
        }
    }
}

