/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dom4j.Element;
import org.opencms.util.CmsPath;
import org.opencms.util.CmsStringUtil;

public class CmsAlternativeSiteRootMapping
implements Serializable {
    public static final String N_ALTERNATIVE_SITE_ROOT_MAPPING = "alternative-site-root";
    public static final String N_PATH = "path";
    public static final String A_TITLE_SUFFIX = "title-suffix";
    private static final long serialVersionUID = 1L;
    private List<CmsPath> m_prefixes;
    private CmsPath m_siteRoot;
    private String m_titleSuffix;

    public CmsAlternativeSiteRootMapping(String siteRoot, List<String> prefixes, String titleSuffix) {
        this.m_siteRoot = new CmsPath(siteRoot);
        this.m_titleSuffix = titleSuffix != null ? titleSuffix : "";
        this.m_prefixes = prefixes.stream().filter(prefix -> prefix != null).map(prefix -> prefix.trim()).filter(prefix -> !prefix.equals("/") && !CmsStringUtil.isEmptyOrWhitespaceOnly(prefix)).map(CmsPath::new).collect(Collectors.toList());
        Collections.sort(this.m_prefixes);
    }

    public void appendXml(Element parent) {
        Element mapping = parent.addElement(N_ALTERNATIVE_SITE_ROOT_MAPPING);
        mapping.addAttribute("uri", this.m_siteRoot.asString());
        mapping.addAttribute(A_TITLE_SUFFIX, this.m_titleSuffix);
        for (CmsPath path : this.getPrefixes()) {
            mapping.addElement(N_PATH).addText(path.asString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsAlternativeSiteRootMapping)) {
            return false;
        }
        CmsAlternativeSiteRootMapping that = (CmsAlternativeSiteRootMapping)obj;
        return that.getSiteRoot().equals(this.getSiteRoot()) && that.getPrefixes().equals(this.getPrefixes()) && that.getTitleSuffix().equals(this.getTitleSuffix());
    }

    public List<CmsPath> getPrefixes() {
        return Collections.unmodifiableList(this.m_prefixes);
    }

    public CmsPath getSiteRoot() {
        return this.m_siteRoot;
    }

    public String getTitleSuffix() {
        return this.m_titleSuffix;
    }

    public int hashCode() {
        return (this.m_prefixes.hashCode() * 31 + this.m_siteRoot.hashCode()) * 31 + this.m_titleSuffix.hashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

