/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security.twofactor;

import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.CodeVerifier;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.code.HashingAlgorithm;
import dev.samstevens.totp.exceptions.QrGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.qr.ZxingPngQrGenerator;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.secret.SecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import dev.samstevens.totp.util.Utils;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.crypto.CmsAESTextEncryption;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsUser;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsUserLog;
import org.opencms.security.twofactor.CmsSecondFactorInfo;
import org.opencms.security.twofactor.CmsSecondFactorSetupException;
import org.opencms.security.twofactor.CmsSecondFactorSetupInfo;
import org.opencms.security.twofactor.CmsTwoFactorAuthenticationConfig;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.CmsWorkplaceMessages;

public class CmsTwoFactorAuthenticationHandler {
    public static final HashingAlgorithm ALGORITHM = HashingAlgorithm.SHA1;
    public static final String ATTR_TWOFACTOR_INFO = "two_factor_auth";
    public static final int DIGITS = 6;
    public static final String KEY_SECRET = "secret";
    public static final String KEY_USER = "user";
    private static final Log LOG = CmsLog.getLog(CmsTwoFactorAuthenticationHandler.class);
    private CmsObject m_cms;
    private final CodeGenerator m_codeGenerator = new DefaultCodeGenerator(ALGORITHM, 6);
    private CmsTwoFactorAuthenticationConfig m_config;
    private CmsAESTextEncryption m_encryption;
    private final SecretGenerator m_secretGenerator = new DefaultSecretGenerator();
    private final TimeProvider m_timeProvider = new SystemTimeProvider();
    private final CodeVerifier m_verifier = new DefaultCodeVerifier(this.m_codeGenerator, this.m_timeProvider);

    public CmsTwoFactorAuthenticationHandler(CmsObject adminCms, CmsTwoFactorAuthenticationConfig config) {
        this.m_config = config;
        this.m_cms = adminCms;
        if (config != null) {
            this.m_encryption = new CmsAESTextEncryption(config.getSecret());
        }
    }

    public CmsSecondFactorSetupInfo generateSetupInfo(CmsUser user) {
        this.checkEnabled();
        try {
            String secret = this.m_secretGenerator.generate();
            String issuer = this.m_config.getIssuer();
            int period = 30;
            String label = user.getFullName();
            QrData qrData = new QrData.Builder().label(label).secret(secret).issuer(issuer).algorithm(ALGORITHM).digits(6).period(period).build();
            ZxingPngQrGenerator generator = new ZxingPngQrGenerator();
            byte[] imageData = generator.generate(qrData);
            String qrImageData = Utils.getDataUriForImage((byte[])imageData, (String)"image/png");
            return new CmsSecondFactorSetupInfo(secret, qrImageData);
        }
        catch (QrGenerationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSetupMessage(Locale locale) {
        String rawMessage = this.m_config.getSetupMessage();
        CmsMacroResolver resolver = new CmsMacroResolver();
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
        resolver.setMessages(messages);
        return resolver.resolveMacros(rawMessage);
    }

    public boolean hasSecondFactor(CmsUser user) {
        return user.getAdditionalInfo().containsKey(ATTR_TWOFACTOR_INFO);
    }

    public boolean isEnabled() {
        return this.m_config != null && this.m_config.isEnabled();
    }

    public boolean needsTwoFactorAuthentication(CmsUser user) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = this.m_config.getPolicy().shouldUseTwoFactorAuthentication(this.m_cms, user);
        return result;
    }

    public void resetTwoFactorAuthentication(CmsUser user) {
        user.deleteAdditionalInfo(ATTR_TWOFACTOR_INFO);
    }

    public boolean setUpAndVerifySecondFactor(CmsUser newUser, CmsSecondFactorInfo code) throws CmsSecondFactorSetupException {
        this.checkEnabled();
        String secret = code.getSecret();
        if (secret == null) {
            throw new CmsSecondFactorSetupException("Secret must not be null.");
        }
        JSONObject secondFactorInfo = this.decodeSecondFactor(newUser);
        if (secondFactorInfo != null) {
            throw new CmsSecondFactorSetupException("Two-factor authentication already set up.");
        }
        try {
            secondFactorInfo = new JSONObject();
            secondFactorInfo.put(KEY_SECRET, secret);
            secondFactorInfo.put(KEY_USER, newUser.getName());
            if (this.m_verifier.isValidCode(secret, code.getCode())) {
                this.encodeSecondFactor(newUser, secondFactorInfo);
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            throw new CmsSecondFactorSetupException(e);
        }
    }

    public void trackUserChange(CmsRequestContext requestContext, CmsUser oldUser, CmsUser newUser) {
        String info1 = (String)oldUser.getAdditionalInfo(ATTR_TWOFACTOR_INFO);
        String info2 = (String)newUser.getAdditionalInfo(ATTR_TWOFACTOR_INFO);
        if (info1 == null && info2 == null) {
            return;
        }
        if (info1 == null && info2 != null) {
            CmsUserLog.logSecondFactorAdded(requestContext, oldUser.getName());
        } else if (info1 != null && info2 == null) {
            CmsUserLog.logSecondFactorReset(requestContext, oldUser.getName());
        } else if (!info1.equals(info2)) {
            CmsUserLog.logSecondFactorInfoModified(requestContext, oldUser.getName());
        }
    }

    public boolean verifySecondFactor(CmsUser user, CmsSecondFactorInfo secondFactorInfo) {
        if (secondFactorInfo == null) {
            return false;
        }
        if (secondFactorInfo.getSecret() != null) {
            LOG.warn((Object)"Secret set in second-factor information for non-setup case", (Throwable)new Exception());
        }
        JSONObject secondFactorJson = this.decodeSecondFactor(user);
        if (!user.getName().equals(secondFactorJson.optString(KEY_USER))) {
            LOG.error((Object)("User mismatch for two-factor authentication data for user: " + user.getName()));
            return false;
        }
        String secret = secondFactorJson.optString(KEY_SECRET);
        boolean result = this.m_verifier.isValidCode(secret, secondFactorInfo.getCode());
        return result;
    }

    public boolean verifySecondFactorSetup(CmsSecondFactorInfo secondFactorInfo) {
        return this.m_verifier.isValidCode(secondFactorInfo.getSecret(), secondFactorInfo.getCode());
    }

    private void checkEnabled() {
        if (!this.isEnabled()) {
            throw new UnsupportedOperationException("Two-factor authentication is disabled");
        }
    }

    private JSONObject decodeSecondFactor(CmsUser user) {
        try {
            String val = (String)user.getAdditionalInfo().get(ATTR_TWOFACTOR_INFO);
            if (val == null) {
                return null;
            }
            JSONObject result = new JSONObject(this.m_encryption.decrypt(val));
            return result;
        }
        catch (CmsEncryptionException | JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private void encodeSecondFactor(CmsUser user, JSONObject json) {
        try {
            user.getAdditionalInfo().put(ATTR_TWOFACTOR_INFO, this.m_encryption.encrypt(json.toString()));
        }
        catch (CmsEncryptionException e) {
            throw new RuntimeException(e);
        }
    }
}

