/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.A_CmsModeIntEnumeration;

public interface I_CmsPermissionHandler {
    public static final CmsPermissionCheckResult PERM_ALLOWED = CmsPermissionCheckResult.ALLOWED;
    public static final CmsPermissionCheckResult PERM_DENIED = CmsPermissionCheckResult.DENIED;
    public static final CmsPermissionCheckResult PERM_FILTERED = CmsPermissionCheckResult.FILTERED;
    public static final CmsPermissionCheckResult PERM_NOTLOCKED = CmsPermissionCheckResult.NOTLOCKED;

    public CmsPermissionCheckResult hasPermissions(CmsDbContext var1, CmsResource var2, CmsPermissionSet var3, LockCheck var4, CmsResourceFilter var5) throws CmsException;

    public void init(CmsDriverManager var1, CmsSystemConfiguration var2);

    public static final class CmsPermissionCheckResult
    extends A_CmsModeIntEnumeration {
        protected static final CmsPermissionCheckResult ALLOWED = new CmsPermissionCheckResult(1);
        protected static final CmsPermissionCheckResult DENIED = new CmsPermissionCheckResult(2);
        protected static final CmsPermissionCheckResult FILTERED = new CmsPermissionCheckResult(3);
        protected static final CmsPermissionCheckResult NOTLOCKED = new CmsPermissionCheckResult(4);
        private static final long serialVersionUID = 2398277834335860916L;

        private CmsPermissionCheckResult(int mode) {
            super(mode);
        }

        public boolean isAllowed() {
            return this == ALLOWED;
        }
    }

    public static enum LockCheck {
        no("N"),
        shallowOnly("S"),
        yes("Y");

        private String m_code;

        private LockCheck(String code) {
            this.m_code = code;
        }

        public String getCode() {
            return this.m_code;
        }
    }
}

