/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;

public class CmsUserLog {
    private static final Log LOG = CmsLog.getLog(CmsUserLog.class);

    public static void logLogin(CmsObject cms, String user) {
        LOG.info((Object)("login successful: " + CmsUserLog.formatUser(user) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logLoginFailure(CmsObject cms, String user) {
        LOG.info((Object)("login failed: " + CmsUserLog.formatUser(user) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logLogout(CmsObject cms) {
        LOG.info((Object)("logout: " + CmsUserLog.formatUser(cms.getRequestContext().getCurrentUser().getName()) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logPasswordChange(CmsObject cms, String user) {
        LOG.info((Object)("password changed: " + CmsUserLog.formatUser(user) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logPasswordChangeForRequestedReset(CmsObject cms, String user) {
        LOG.info((Object)("password changed (reset requested): " + CmsUserLog.formatUser(user) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logPasswordResetRequest(CmsObject cms, String user) {
        LOG.info((Object)("password reset request: " + user + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logSecondFactorAdded(CmsRequestContext requestContext, String name) {
        LOG.info((Object)("second factor added: " + CmsUserLog.formatUser(name) + " " + String.valueOf(CmsUserLog.context(requestContext))));
    }

    public static void logSecondFactorInfoModified(CmsRequestContext requestContext, String name) {
        LOG.info((Object)("second factor information modified: " + CmsUserLog.formatUser(name) + " " + String.valueOf(CmsUserLog.context(requestContext))));
    }

    public static void logSecondFactorReset(CmsRequestContext requestContext, String name) {
        LOG.info((Object)("second factor reset: " + CmsUserLog.formatUser(name) + " " + String.valueOf(CmsUserLog.context(requestContext))));
    }

    public static void logSetForceResetPassword(CmsObject cms, String user) {
        LOG.info((Object)("forcing password reset on next login: " + user + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    public static void logSwitchUser(CmsObject cms, String name) {
        LOG.info((Object)("user switch: " + CmsUserLog.formatUser(cms.getRequestContext().getCurrentUser().getName()) + " => " + CmsUserLog.formatUser(name) + " " + String.valueOf(CmsUserLog.context(cms))));
    }

    private static TreeMap<String, String> context(CmsObject cms) {
        return CmsUserLog.context(cms.getRequestContext());
    }

    private static TreeMap<String, String> context(CmsRequestContext requestContext) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("remote_address", requestContext.getRemoteAddress());
        result.put("current_user", requestContext.getCurrentUser().getName());
        return result;
    }

    private static String formatUser(String userName) {
        return CmsFileUtil.removeLeadingSeparator(userName);
    }
}

