/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsPersistentLoginTokenHandler {
    public static final long DEFAULT_LIFETIME = 28800000L;
    public static final String KEY_PREFIX = "logintoken_";
    private static final Log LOG = CmsLog.getLog(CmsPersistentLoginTokenHandler.class);
    private static CmsObject m_adminCms;
    private long m_lifetime = 28800000L;

    public static void setAdminCms(CmsObject adminCms) {
        if (m_adminCms == null) {
            m_adminCms = adminCms;
        }
    }

    public String createToken(CmsObject cms) throws CmsException {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String key = RandomStringUtils.randomAlphanumeric((int)16);
        Token tokenObj = new Token(user.getName(), key);
        String token = tokenObj.encode();
        String addInfoKey = tokenObj.getAdditionalInfoKey();
        String value = "" + (System.currentTimeMillis() + this.m_lifetime);
        user.getAdditionalInfo().put(addInfoKey, value);
        this.removeExpiredTokens(user, System.currentTimeMillis());
        LOG.info((Object)("Generated token for user " + user.getName() + " using key " + key));
        m_adminCms.writeUser(user);
        return token;
    }

    public void invalidateToken(CmsUser user, String token) throws CmsException {
        Token tokenObj = new Token(token);
        if (tokenObj.isValid()) {
            String addInfoKey = tokenObj.getAdditionalInfoKey();
            if (null != user.getAdditionalInfo().remove(addInfoKey)) {
                m_adminCms.writeUser(user);
            }
        }
    }

    public void removeExpiredTokens(CmsUser user, long now) {
        ArrayList toRemove = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : user.getAdditionalInfo().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(KEY_PREFIX)) continue;
            try {
                long expiry = Long.parseLong((String)entry.getValue());
                if (expiry >= now) continue;
                toRemove.add(key);
            }
            catch (NumberFormatException e) {
                toRemove.add(key);
            }
        }
        LOG.info((Object)("Removing " + toRemove.size() + " expired tokens for user " + user.getName()));
        for (String removeKey : toRemove) {
            user.getAdditionalInfo().remove(removeKey);
        }
    }

    public void setTokenLifetime(long duration) {
        this.m_lifetime = duration;
    }

    public CmsUser validateToken(String tokenString) {
        if (CmsStringUtil.isEmpty(tokenString)) {
            return null;
        }
        Token token = new Token(tokenString);
        if (!token.isValid()) {
            LOG.warn((Object)("Invalid token: " + tokenString));
            return null;
        }
        String name = token.getName();
        String key = token.getKey();
        String logContext = "[user=" + name + ",key=" + key + "] ";
        try {
            CmsUser user;
            block9: {
                user = m_adminCms.readUser(name);
                String infoKey = token.getAdditionalInfoKey();
                String addInfoValue = (String)user.getAdditionalInfo().get(infoKey);
                logContext = logContext + "[value=" + addInfoValue + "]";
                if (addInfoValue == null) {
                    LOG.warn((Object)(logContext + " no matching additional info value found"));
                    return null;
                }
                try {
                    long expirationDate = Long.parseLong(addInfoValue);
                    if (System.currentTimeMillis() <= expirationDate) break block9;
                    LOG.warn((Object)(logContext + "Login token expired"));
                    user.getAdditionalInfo().remove(infoKey);
                    try {
                        m_adminCms.writeUser(user);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)(logContext + "Invalid format for login token additional info"));
                    return null;
                }
            }
            return user;
        }
        catch (Exception e) {
            LOG.warn((Object)(logContext + "error validating token"), (Throwable)e);
            return null;
        }
    }

    public static class Token {
        public static final String SEPARATOR = "|";
        private String m_key;
        private String m_name;

        public Token(String token) {
            List<String> parts;
            if (token != null && (parts = CmsStringUtil.splitAsList(token, SEPARATOR)).size() == 2) {
                this.m_name = this.decodeName(parts.get(0));
                this.m_key = parts.get(1);
            }
        }

        public Token(String name, String key) {
            this.m_name = name;
            this.m_key = key;
        }

        public String encode() {
            return this.encodeName(this.m_name) + SEPARATOR + this.m_key;
        }

        public String getAdditionalInfoKey() {
            return CmsPersistentLoginTokenHandler.KEY_PREFIX + this.m_key;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean isValid() {
            return this.m_name != null && this.m_key != null;
        }

        private String decodeName(String nameHex) {
            try {
                return new String(Hex.decodeHex((char[])nameHex.toCharArray()), "UTF-8");
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        private String encodeName(String name) {
            try {
                return Hex.encodeHexString((byte[])name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF8 not supported");
            }
        }
    }
}

