/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.StringTokenizer;
import org.opencms.security.CmsPermissionSet;

public class CmsPermissionSetCustom
extends CmsPermissionSet {
    private static final long serialVersionUID = -8537313517987611085L;
    private boolean m_cacheable = true;

    public CmsPermissionSetCustom() {
    }

    public CmsPermissionSetCustom(CmsPermissionSet permissions) {
        this.m_allowed = permissions.m_allowed;
        this.m_denied = permissions.m_denied;
    }

    public CmsPermissionSetCustom(int allowedPermissions) {
        super(allowedPermissions);
    }

    public CmsPermissionSetCustom(int allowedPermissions, int deniedPermissions) {
        super(allowedPermissions, deniedPermissions);
    }

    public CmsPermissionSetCustom(String permissionString) {
        StringTokenizer tok = new StringTokenizer(permissionString, "+-", true);
        this.m_allowed = 0;
        this.m_denied = 0;
        while (tok.hasMoreElements()) {
            String prefix = tok.nextToken();
            String suffix = tok.nextToken();
            switch (suffix.charAt(0)) {
                case 'R': 
                case 'r': {
                    if (prefix.charAt(0) == '+') {
                        this.m_allowed |= 1;
                    }
                    if (prefix.charAt(0) != '-') break;
                    this.m_denied |= 1;
                    break;
                }
                case 'W': 
                case 'w': {
                    if (prefix.charAt(0) == '+') {
                        this.m_allowed |= 2;
                    }
                    if (prefix.charAt(0) != '-') break;
                    this.m_denied |= 2;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (prefix.charAt(0) == '+') {
                        this.m_allowed |= 4;
                    }
                    if (prefix.charAt(0) != '-') break;
                    this.m_denied |= 4;
                    break;
                }
                case 'C': 
                case 'c': {
                    if (prefix.charAt(0) == '+') {
                        this.m_allowed |= 8;
                    }
                    if (prefix.charAt(0) != '-') break;
                    this.m_denied |= 8;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (prefix.charAt(0) == '+') {
                        this.m_allowed |= 0x10;
                    }
                    if (prefix.charAt(0) != '-') break;
                    this.m_denied |= 0x10;
                    break;
                }
            }
        }
    }

    public void addPermissions(CmsPermissionSet permissionSet) {
        this.m_allowed |= permissionSet.m_allowed;
        this.m_denied |= permissionSet.m_denied;
    }

    public Object clone() {
        return new CmsPermissionSetCustom(this.m_allowed, this.m_denied);
    }

    public void denyPermissions(int permissions) {
        this.m_denied |= permissions;
    }

    public void grantPermissions(int permissions) {
        this.m_allowed |= permissions;
    }

    public boolean isCacheable() {
        return this.m_cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.m_cacheable = cacheable;
    }

    public void setPermissions(CmsPermissionSet permissionSet) {
        this.m_allowed = permissionSet.m_allowed;
        this.m_denied = permissionSet.m_denied;
    }

    public void setPermissions(int allowedPermissions, int deniedPermissions) {
        this.m_allowed = allowedPermissions;
        this.m_denied = deniedPermissions;
    }
}

