/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import com.lambdaworks.crypto.SCryptUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsDefaultPasswordGenerator;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPasswordGenerator;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsPasswordSecurityEvaluator;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultPasswordHandler
implements I_CmsPasswordHandler,
I_CmsPasswordSecurityEvaluator,
I_CmsPasswordGenerator {
    public static String PARAM_SCRYPT_FALLBACK = "scrypt.fallback";
    public static String PARAM_SCRYPT_SETTINGS = "scrypt.settings";
    public static final int PASSWORD_MIN_LENGTH = 4;
    public static final int PASSWORD_SECURE_LENGTH = 8;
    private static final Log LOG = CmsLog.getLog(CmsDefaultPasswordHandler.class);
    private static SecureRandom m_secureRandom;
    private CmsParameterConfiguration m_configuration = new CmsParameterConfiguration();
    private String m_digestType = "scrypt";
    private String m_inputEncoding = "UTF-8";
    private String m_scryptFallback;
    private int m_scryptN;
    private int m_scryptP;
    private int m_scryptR;

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.put(paramName, paramValue);
    }

    @Override
    public boolean checkPassword(String plainPassword, String digestedPassword, boolean useFallback) {
        boolean success;
        block6: {
            block8: {
                block7: {
                    success = false;
                    if (!"plain".equals(this.m_digestType)) break block7;
                    success = plainPassword.equals(digestedPassword);
                    break block6;
                }
                if (!"scrypt".equals(this.m_digestType)) break block8;
                try {
                    success = SCryptUtil.check((String)plainPassword, (String)digestedPassword);
                }
                catch (IllegalArgumentException e) {
                    if (!useFallback) break block6;
                    try {
                        success = digestedPassword.equals(this.digest(plainPassword, this.m_scryptFallback, this.m_inputEncoding));
                        break block6;
                    }
                    catch (CmsPasswordEncryptionException cmsPasswordEncryptionException) {}
                }
                break block6;
            }
            try {
                success = digestedPassword.equals(this.digest(plainPassword));
            }
            catch (CmsPasswordEncryptionException cmsPasswordEncryptionException) {
                // empty catch block
            }
        }
        return success;
    }

    @Override
    public String digest(String password) throws CmsPasswordEncryptionException {
        return this.digest(password, this.m_digestType, this.m_inputEncoding);
    }

    @Override
    public String digest(String password, String digestType, String inputEncoding) throws CmsPasswordEncryptionException {
        String result;
        try {
            if ("plain".equals(digestType.toLowerCase())) {
                result = password;
            } else if ("scrypt".equals(digestType.toLowerCase())) {
                result = SCryptUtil.scrypt((String)password, (int)this.m_scryptN, (int)this.m_scryptR, (int)this.m_scryptP);
            } else if ("ssha".equals(digestType.toLowerCase())) {
                byte[] salt = new byte[4];
                if (m_secureRandom == null) {
                    m_secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                m_secureRandom.nextBytes(salt);
                MessageDigest md = MessageDigest.getInstance("sha");
                md.reset();
                md.update(password.getBytes(inputEncoding));
                md.update(salt);
                byte[] digest = md.digest();
                byte[] total = new byte[digest.length + salt.length];
                System.arraycopy(digest, 0, total, 0, digest.length);
                System.arraycopy(salt, 0, total, digest.length, salt.length);
                result = new String(Base64.encodeBase64((byte[])total));
            } else {
                MessageDigest md = MessageDigest.getInstance(digestType);
                md.reset();
                md.update(password.getBytes(inputEncoding));
                result = new String(Base64.encodeBase64((byte[])md.digest()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            CmsMessageContainer message = Messages.get().container("ERR_UNSUPPORTED_ALGORITHM_1", digestType);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsPasswordEncryptionException(message, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            CmsMessageContainer message = Messages.get().container("ERR_UNSUPPORTED_PASSWORD_ENCODING_1", inputEncoding);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsPasswordEncryptionException(message, (Throwable)e);
        }
        return result;
    }

    @Override
    public I_CmsPasswordSecurityEvaluator.SecurityLevel evaluatePasswordSecurity(String password) {
        I_CmsPasswordSecurityEvaluator.SecurityLevel result = password.length() < 4 ? I_CmsPasswordSecurityEvaluator.SecurityLevel.invalid : (password.length() < 8 ? I_CmsPasswordSecurityEvaluator.SecurityLevel.weak : I_CmsPasswordSecurityEvaluator.SecurityLevel.strong);
        return result;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public String getDigestType() {
        return this.m_digestType;
    }

    @Override
    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    @Override
    public String getPasswordSecurityHint(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_PASSWORD_SECURITY_HINT_1", 8);
    }

    @Override
    public String getRandomPassword() {
        return CmsDefaultPasswordGenerator.getRandomPWD();
    }

    @Override
    public void initConfiguration() {
        block8: {
            if (LOG.isDebugEnabled()) {
                CmsMessageContainer message = Messages.get().container("LOG_INIT_CONFIG_CALLED_1", this);
                LOG.debug((Object)message.key());
                LOG.debug((Object)Messages.get().getBundle().key("LOG_INIT_CONFIG_CALLED_1", this));
            }
            this.m_configuration = CmsParameterConfiguration.unmodifiableVersion(this.m_configuration);
            this.m_scryptN = 16384;
            this.m_scryptR = 8;
            this.m_scryptP = 1;
            String scryptSettings = this.m_configuration.get(PARAM_SCRYPT_SETTINGS);
            if (scryptSettings != null) {
                String[] settings = CmsStringUtil.splitAsArray(scryptSettings, ',');
                if (settings.length == 3) {
                    this.m_scryptN = CmsStringUtil.getIntValue(settings[0], this.m_scryptN, "scryptN using " + this.m_scryptN);
                    this.m_scryptR = CmsStringUtil.getIntValue(settings[1], this.m_scryptR, "scryptR using " + this.m_scryptR);
                    this.m_scryptP = CmsStringUtil.getIntValue(settings[2], this.m_scryptP, "scryptP using " + this.m_scryptP);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRYPT_PARAMETERS_1", scryptSettings));
                }
            }
            this.m_scryptFallback = "md5";
            String scryptFallback = this.m_configuration.get(PARAM_SCRYPT_FALLBACK);
            if (scryptFallback != null) {
                try {
                    MessageDigest.getInstance(scryptFallback);
                    this.m_scryptFallback = scryptFallback;
                }
                catch (NoSuchAlgorithmException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRYPT_PARAMETERS_1", scryptFallback));
                }
            }
        }
    }

    @Override
    public void setDigestType(String digestType) {
        this.m_digestType = digestType.toLowerCase();
    }

    @Override
    public void setInputEncoding(String inputEncoding) {
        this.m_inputEncoding = inputEncoding;
    }

    @Override
    public void validatePassword(String password) throws CmsSecurityException {
        if (password == null || password.length() < 4) {
            throw new CmsSecurityException(Messages.get().container("ERR_PASSWORD_TOO_SHORT_1", 4));
        }
    }
}

