/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.A_CmsAuthorizationHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.Messages;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsDefaultAuthorizationHandler
extends A_CmsAuthorizationHandler {
    public static final String PARAM_HTTP_BASICAUTH_USESTARTSETTINGS_PATHS = "http.basicauth.usestartsettings.paths";
    public static final String PARAM_HTTP_BASICAUTH_USESTARTSETTINGS_USERS = "http.basicauth.usestartsettings.users";
    public static final String AUTHORIZATION_BASIC_PREFIX = "BASIC ";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String PARAM_ENCRYPTED_REQUESTED_RESOURCE = "encryptedRequestedResource";
    public static final String SEPARATOR_CREDENTIALS = ":";

    protected static boolean checkPath(String uri, String pathSpec) {
        String[] pathPatterns;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(pathSpec)) {
            return false;
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        pathSpec = resolver.resolveMacros(pathSpec);
        for (String pathToken : pathPatterns = pathSpec.split(",")) {
            if (!CmsStringUtil.isPrefixPath(pathToken, uri)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkUser(CmsObject cms, String userSpec) {
        String[] entries;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userSpec)) {
            return false;
        }
        Set groupsOfUser = null;
        for (String userSpecEntry : entries = userSpec.split(",")) {
            if ("*".equals(userSpecEntry = userSpecEntry.trim())) {
                return true;
            }
            if (userSpecEntry.startsWith("USER")) {
                String userName = CmsUser.removePrefix(userSpecEntry);
                if (!cms.getRequestContext().getCurrentUser().getName().equals(userName)) continue;
                return true;
            }
            if (userSpecEntry.startsWith("ROLE")) {
                String actualRole = CmsRole.removePrefix(userSpecEntry);
                CmsRole roleObj = null;
                roleObj = actualRole.contains("/") ? CmsRole.valueOfRoleName(actualRole) : CmsRole.valueOfRoleName(actualRole).forOrgUnit(null);
                if (!OpenCms.getRoleManager().hasRole(cms, roleObj)) continue;
                return true;
            }
            if (!userSpecEntry.startsWith("GROUP")) continue;
            String groupName = CmsGroup.removePrefix(userSpecEntry);
            if (groupsOfUser == null) {
                try {
                    groupsOfUser = cms.getGroupsOfUser(cms.getRequestContext().getCurrentUser().getName(), false).stream().map(group -> group.getName()).collect(Collectors.toSet());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
            }
            if (!groupsOfUser.contains(groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLoginFormURL(String loginFormURL, String params, String callbackURL) {
        if (loginFormURL != null) {
            StringBuffer fullURL = new StringBuffer(loginFormURL);
            if (callbackURL != null) {
                fullURL.append("?");
                fullURL.append("requestedResource");
                fullURL.append("=");
                fullURL.append(callbackURL);
            }
            ArrayList<Object> paramList = params != null ? new ArrayList<String>(Arrays.asList(params.split("&"))) : new ArrayList();
            if (callbackURL != null) {
                try {
                    paramList.add("encryptedRequestedResource=" + OpenCms.getDefaultTextEncryption().encrypt(CmsEncoder.decode(callbackURL)));
                }
                catch (CmsEncryptionException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            fullURL.append(callbackURL != null ? "&" : "?");
            fullURL.append(Joiner.on((String)"&").join(paramList));
            return fullURL.toString();
        }
        return null;
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request) {
        CmsObject cms = this.checkBasicAuthorization(request);
        if (cms != null) {
            try {
                return this.registerSession(request, cms);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request, I_CmsAuthorizationHandler.I_PrivilegedLoginAction loginAction) {
        return this.initCmsObject(request);
    }

    @Override
    public CmsObject initCmsObject(HttpServletRequest request, String userName, String pwd) throws CmsException {
        CmsObject cms = this.initCmsObjectFromSession(request);
        if (cms != null) {
            return cms;
        }
        cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        cms.loginUser(userName, pwd);
        return this.registerSession(request, cms);
    }

    @Override
    public void requestAuthorization(HttpServletRequest req, HttpServletResponse res, String loginFormURL) throws IOException {
        CmsHttpAuthenticationSettings httpAuthenticationSettings = OpenCms.getSystemInfo().getHttpAuthenticationSettings();
        if (loginFormURL == null) {
            if (httpAuthenticationSettings.useBrowserBasedHttpAuthentication()) {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"" + OpenCms.getSystemInfo().getServerName() + "\"");
                res.setStatus(401);
                return;
            }
            if (httpAuthenticationSettings.getFormBasedHttpAuthenticationUri() != null) {
                loginFormURL = httpAuthenticationSettings.getFormBasedHttpAuthenticationUri();
            } else {
                LOG.error((Object)Messages.get().getBundle().key("ERR_UNSUPPORTED_AUTHENTICATION_MECHANISM_1", httpAuthenticationSettings.getBrowserBasedAuthenticationMechanism()));
                res.setStatus(500);
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_AUTHENTICATE_PROPERTY_2", loginFormURL, req.getRequestURI()));
        }
        res.sendRedirect(loginFormURL);
    }

    protected CmsObject checkBasicAuthorization(HttpServletRequest req) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checking for basic authorization.");
        }
        try {
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            if (OpenCms.getSystemInfo().getHttpAuthenticationSettings().getBrowserBasedAuthenticationMechanism() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Browser based authorization not enabled.");
                }
                return cms;
            }
            String auth = req.getHeader(HEADER_AUTHORIZATION);
            if (auth == null || !auth.toUpperCase().startsWith(AUTHORIZATION_BASIC_PREFIX)) {
                return cms;
            }
            String base64Token = auth.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = null;
            String password = null;
            int pos = token.indexOf(SEPARATOR_CREDENTIALS);
            if (pos != -1) {
                username = token.substring(0, pos);
                password = token.substring(pos + 1);
            }
            cms.loginUser(username, password);
            HttpSession session = req.getSession(true);
            String requestUri = req.getRequestURI();
            boolean isWorkplace = requestUri.startsWith(OpenCms.getSystemInfo().getWorkplaceContext()) || requestUri.startsWith(CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/system/workplace"));
            isWorkplace = isWorkplace && OpenCms.getRoleManager().hasRole(cms, CmsRole.ELEMENT_AUTHOR);
            LOG.debug((Object)("isWorkplace = " + isWorkplace));
            boolean initStartSettings = isWorkplace || this.shouldUseStartSettingsForHttpBasicAuth(cms, req);
            LOG.debug((Object)("initStartSettings = " + initStartSettings));
            OpenCms.getSiteManager().isWorkplaceRequest(req);
            if (initStartSettings) {
                CmsWorkplaceSettings settings = CmsLoginHelper.initSiteAndProject(cms);
                session.setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
            }
            return cms;
        }
        catch (CmsException e) {
            return null;
        }
    }

    protected boolean shouldUseStartSettingsForHttpBasicAuth(CmsObject cms, HttpServletRequest req) {
        String userSpec = (String)this.m_parameters.get(PARAM_HTTP_BASICAUTH_USESTARTSETTINGS_USERS);
        String pathSpec = (String)this.m_parameters.get(PARAM_HTTP_BASICAUTH_USESTARTSETTINGS_PATHS);
        if (!CmsDefaultAuthorizationHandler.checkPath(req.getRequestURI(), pathSpec)) {
            LOG.debug((Object)("checkPath returned false for " + req.getRequestURI() + ", pathSpec=" + pathSpec));
            return false;
        }
        if (!CmsDefaultAuthorizationHandler.checkUser(cms, userSpec)) {
            LOG.debug((Object)("checkUser returned false for " + cms.getRequestContext().getCurrentUser().getName() + ", userSpec = " + userSpec));
            return false;
        }
        return true;
    }
}

