/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr.updateprocessors;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.opencms.search.solr.updateprocessors.CmsSolrCopyModifiedUpateProcessor;

public class CmsSolrCopyModifiedUpateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_REPLACEMENT = "replacement";
    private static final String PARAM_SOURCE = "source";
    private static final String PARAM_TARGET = "target";
    private Pattern m_regex;
    private String m_replacement;
    private String m_source;
    private String m_target;

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new CmsSolrCopyModifiedUpateProcessor(this.m_source, this.m_target, this.m_regex, this.m_replacement, next);
    }

    public void init(NamedList args) {
        Object regex = args.remove(PARAM_REGEX);
        if (null == regex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: regex");
        }
        try {
            this.m_regex = Pattern.compile(regex.toString());
        }
        catch (PatternSyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid regex: " + String.valueOf(regex), (Throwable)e);
        }
        Object replacement = args.remove(PARAM_REPLACEMENT);
        if (null == replacement) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: replacement");
        }
        this.m_replacement = replacement.toString();
        Object source = args.remove(PARAM_SOURCE);
        if (null == source) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: source");
        }
        this.m_source = source.toString();
        Object target = args.remove(PARAM_TARGET);
        if (null == target) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: target");
        }
        this.m_target = target.toString();
    }
}

