/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr.spellchecking;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.util.CmsStringUtil;

public final class CmsSpellcheckDictionaryIndexer {
    private static final Log LOG = CmsLog.getLog(OpenCmsServlet.class);
    public static final String DEFAULT_DICTIONARY_DIRECTORY = "/system/workplace/editors/spellcheck";
    public static final String INDEXES_REGEX = "spellchecker_[a-z]{2}";
    public static final String CUSTOM_DICTIONARY = "custom_dict_[a-z]{2}.txt";
    public static final String DICTIONARY_NAME_REGEX = "dict_[a-z]{2}.txt";
    public static final String ZIP_NAME_REGEX = "dict_[a-z]{2}.zip";
    private static final int MAX_LIST_SIZE = 100000;
    private static final FileFilter SPELLCHECKING_DIRECTORY_NAME_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.getName().matches(CmsSpellcheckDictionaryIndexer.INDEXES_REGEX);
        }
    };

    private CmsSpellcheckDictionaryIndexer() {
    }

    public static void parseAndAddDictionaries(SolrClient client, CmsObject cms) {
        if (null == client || null == cms) {
            return;
        }
        CmsSpellcheckDictionaryIndexer.setCmsOfflineProject(cms);
        try {
            List<CmsResource> resources = cms.getResourcesInFolder(DEFAULT_DICTIONARY_DIRECTORY, CmsResourceFilter.DEFAULT_FILES);
            for (CmsResource resource : resources) {
                String resourceName = resource.getName();
                String lang = null;
                if (resourceName.matches(DICTIONARY_NAME_REGEX)) {
                    lang = resourceName.substring(5, 7);
                } else if (resourceName.matches(CUSTOM_DICTIONARY)) {
                    lang = resourceName.substring(12, 14);
                }
                if (null == lang) continue;
                CmsFile file = cms.readFile(resource);
                ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
                CmsSpellcheckDictionaryIndexer.readAndAddDocumentsFromStream(client, lang, new ByteArrayInputStream(file.getContents()), documents, true);
                CmsSpellcheckDictionaryIndexer.addDocuments(client, documents, true);
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)"Could not read from resource. ");
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not successfully parse the dictionary. ");
        }
        catch (SolrServerException e) {
            LOG.warn((Object)"Exception while adding documents to Solr server. ");
        }
    }

    public static void parseAndAddZippedDictionaries(SolrClient client, CmsObject cms) {
        try {
            List<CmsResource> resources = cms.getResourcesInFolder(DEFAULT_DICTIONARY_DIRECTORY, CmsResourceFilter.DEFAULT_FILES);
            LinkedList<SolrInputDocument> documents = new LinkedList<SolrInputDocument>();
            for (CmsResource resource : resources) {
                String zipFileName = resource.getName();
                if (!zipFileName.matches(ZIP_NAME_REGEX)) continue;
                CmsFile cmsFile = cms.readFile(resource);
                try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(cmsFile.getContents()));){
                    ZipEntry entry = zipStream.getNextEntry();
                    while (null != entry) {
                        String name = entry.getName();
                        if (!name.matches(DICTIONARY_NAME_REGEX)) continue;
                        String lang = name.substring(5, 7);
                        CmsSpellcheckDictionaryIndexer.readAndAddDocumentsFromStream(client, lang, zipStream, documents, false);
                        entry = zipStream.getNextEntry();
                    }
                }
            }
            CmsSpellcheckDictionaryIndexer.addDocuments(client, documents, true);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed while reading from /system/workplace/editors/spellcheck. ");
        }
        catch (CmsException e) {
            LOG.warn((Object)"Failed reading resource /system/workplace/editors/spellcheck. ");
        }
        catch (SolrServerException e) {
            LOG.warn((Object)"Failed adding documents to Solr server. ");
        }
    }

    public static boolean updatingIndexNecessesary(CmsObject cms) {
        long dateOldestIndexWrite;
        CmsSpellcheckDictionaryIndexer.setCmsOfflineProject(cms);
        if (CmsSpellcheckDictionaryIndexer.isSolrSpellcheckIndexDirectoryEmpty()) {
            return true;
        }
        long dateMostRecentDictionary = CmsSpellcheckDictionaryIndexer.getMostRecentDate(cms);
        return dateMostRecentDictionary > (dateOldestIndexWrite = CmsSpellcheckDictionaryIndexer.getOldestIndexDate(cms));
    }

    static void addDocuments(SolrClient client, List<SolrInputDocument> documents, boolean commit) throws IOException, SolrServerException {
        if (null == client || null == documents) {
            return;
        }
        if (!documents.isEmpty()) {
            client.add(documents);
        }
        if (commit) {
            client.commit();
        }
    }

    static void deleteAllFiles(SolrClient client) throws IOException, SolrServerException {
        if (null == client) {
            return;
        }
        client.deleteByQuery("*:*");
        client.commit();
    }

    static void deleteDocument(SolrClient client, String lang, String word) throws IOException, SolrServerException {
        if (null == client || CmsStringUtil.isEmptyOrWhitespaceOnly(lang) || CmsStringUtil.isEmptyOrWhitespaceOnly(word)) {
            return;
        }
        if (word.trim().contains(" ")) {
            String query = String.format("entry_%s:%s", lang, word);
            client.deleteByQuery(query);
        }
    }

    private static long getMostRecentDate(CmsObject cms) {
        long mostRecentDate = Long.MIN_VALUE;
        try {
            List<CmsResource> resources = cms.getResourcesInFolder(DEFAULT_DICTIONARY_DIRECTORY, CmsResourceFilter.DEFAULT_FILES);
            for (CmsResource resource : resources) {
                String resourceName = resource.getName();
                if (!resourceName.matches(DICTIONARY_NAME_REGEX) && !resourceName.matches(ZIP_NAME_REGEX) && !resourceName.matches(CUSTOM_DICTIONARY) || resource.getDateLastModified() <= mostRecentDate) continue;
                mostRecentDate = resource.getDateLastModified();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Could not read spellchecker dictionaries. ");
        }
        return mostRecentDate;
    }

    private static long getOldestIndexDate(CmsObject cms) {
        File path = new File(CmsSpellcheckDictionaryIndexer.getSolrSpellcheckRfsPath());
        File[] directories = path.listFiles(SPELLCHECKING_DIRECTORY_NAME_FILTER);
        long oldestIndexDate = Long.MAX_VALUE;
        for (File dir : directories) {
            long date = dir.lastModified();
            if (date >= oldestIndexDate) continue;
            oldestIndexDate = date;
        }
        if (Long.MAX_VALUE == oldestIndexDate) {
            LOG.warn((Object)("It appears that no spellcheck indices have been found in " + CmsSpellcheckDictionaryIndexer.getSolrSpellcheckRfsPath() + ". "));
            return Long.MIN_VALUE;
        }
        return oldestIndexDate;
    }

    private static String getSolrSpellcheckRfsPath() {
        Object sPath = OpenCms.getSystemInfo().getWebInfRfsPath();
        if (!OpenCms.getSystemInfo().getWebInfRfsPath().endsWith(File.separator)) {
            sPath = (String)sPath + File.separator;
        }
        return (String)sPath + "solr" + File.separator + "spellcheck" + File.separator + "data";
    }

    private static boolean isSolrSpellcheckIndexDirectoryEmpty() {
        File path = new File(CmsSpellcheckDictionaryIndexer.getSolrSpellcheckRfsPath());
        File[] directories = path.listFiles(SPELLCHECKING_DIRECTORY_NAME_FILTER);
        if (directories != null) {
            for (File directory : directories) {
                if (directory.list().length <= 2) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndAddDocumentsFromStream(SolrClient client, String lang, InputStream is, List<SolrInputDocument> documents, boolean closeStream) {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line = br.readLine();
            while (null != line) {
                SolrInputDocument document = new SolrInputDocument();
                document.addField("entry_" + lang, (Object)line);
                documents.add(document);
                if (documents.size() >= 100000) {
                    CmsSpellcheckDictionaryIndexer.addDocuments(client, documents, false);
                    documents.clear();
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not read spellcheck dictionary from input stream.");
        }
        catch (SolrServerException e) {
            LOG.error((Object)"Error while adding documents to Solr server. ");
        }
        finally {
            try {
                if (closeStream) {
                    br.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static void setCmsOfflineProject(CmsObject cms) {
        if (null == cms) {
            return;
        }
        CmsRequestContext cmsContext = cms.getRequestContext();
        CmsProject cmsProject = cmsContext.getCurrentProject();
        if (cmsProject.isOnlineProject()) {
            try {
                CmsProject cmsOfflineProject = cms.readProject("Offline");
                cmsContext.setCurrentProject(cmsOfflineProject);
            }
            catch (CmsException e) {
                LOG.warn((Object)"Could not set the current project to \"Offline\". ");
            }
        }
    }
}

