/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocumentList;
import org.opencms.search.CmsSearchResource;

public class CmsSolrResultList
extends ArrayList<CmsSearchResource> {
    private static final long serialVersionUID = 707475894827620542L;
    private int m_end;
    private long m_highlightEndTime;
    private Map<String, Map<String, List<String>>> m_highlighting;
    private int m_page;
    private SolrQuery m_query;
    private QueryResponse m_queryResponse;
    private SolrDocumentList m_resultDocuments;
    private Integer m_rows;
    private long m_startTime;
    private long m_visibleHitCount;

    public CmsSolrResultList(SolrQuery query, QueryResponse queryResponse, SolrDocumentList resultDocuments, List<CmsSearchResource> resourceDocumentList, int start, Integer rows, int end, int page, long visibleHitCount, Float maxScore, long startTime, long highlightEndTime) {
        super(resourceDocumentList);
        this.m_query = query;
        this.m_startTime = startTime;
        this.m_highlightEndTime = highlightEndTime;
        this.m_rows = rows;
        this.m_end = end;
        this.m_page = page;
        this.m_visibleHitCount = visibleHitCount;
        this.m_resultDocuments = resultDocuments;
        this.m_queryResponse = queryResponse;
        this.m_highlighting = this.transformHighlighting();
    }

    public int getEnd() {
        return this.m_end;
    }

    public FacetField getFacetDate(String name) {
        return this.m_queryResponse.getFacetDate(name);
    }

    public List<FacetField> getFacetDates() {
        return this.m_queryResponse.getFacetDates();
    }

    public FacetField getFacetField(String name) {
        return this.m_queryResponse.getFacetField(name);
    }

    public List<FacetField> getFacetFields() {
        return this.m_queryResponse.getFacetFields();
    }

    public Map<String, Integer> getFacetQuery() {
        return this.m_queryResponse.getFacetQuery();
    }

    public List<RangeFacet> getFacetRanges() {
        return this.m_queryResponse.getFacetRanges();
    }

    public long getHighlightEndTime() {
        return this.m_highlightEndTime;
    }

    public Map<String, Map<String, List<String>>> getHighLighting() {
        return this.m_highlighting;
    }

    public List<FacetField> getLimitingFacets() {
        return this.m_queryResponse.getLimitingFacets();
    }

    public Float getMaxScore() {
        return this.m_resultDocuments.getMaxScore();
    }

    public long getNumFound() {
        return this.m_resultDocuments.getNumFound();
    }

    public int getPage() {
        return this.m_page;
    }

    public SolrQuery getQuery() {
        return this.m_query;
    }

    public Integer getRows() {
        return this.m_rows;
    }

    public SpellCheckResponse getSpellCheckResponse() {
        return this.m_queryResponse.getSpellCheckResponse();
    }

    public Long getStart() {
        return this.m_resultDocuments.getStart();
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getVisibleHitCount() {
        return this.m_visibleHitCount;
    }

    private Map<String, Map<String, List<String>>> transformHighlighting() {
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>();
        if (this.m_queryResponse.getHighlighting() != null) {
            for (String key : this.m_queryResponse.getHighlighting().keySet()) {
                Map value = (Map)this.m_queryResponse.getHighlighting().get(key);
                HashMap<String, List<String>> innerResult = new HashMap<String, List<String>>();
                for (String innerKey : value.keySet()) {
                    Object li;
                    Object entry = value.get(innerKey);
                    ArrayList<String> innerList = new ArrayList<String>();
                    if (entry instanceof String) {
                        innerResult.put(innerKey, Collections.singletonList((String)entry));
                        continue;
                    }
                    if (entry instanceof String[]) {
                        for (Object lo : li = (String[])entry) {
                            String s = (String)lo;
                            innerList.add(s);
                        }
                        innerResult.put(innerKey, innerList);
                        continue;
                    }
                    if (!(entry instanceof List)) continue;
                    li = (List)entry;
                    Iterator iterator = li.iterator();
                    while (iterator.hasNext()) {
                        Object lo = iterator.next();
                        String s = (String)lo;
                        innerList.add(s);
                    }
                    innerResult.put(innerKey, innerList);
                }
                result.put(key, innerResult);
            }
        }
        return result;
    }
}

