/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrQuery;
import org.opencms.ade.configuration.CmsFunctionAvailability;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsUUID;

public class CmsGallerySearchParameters {
    private static final Log LOG = CmsLog.getLog(CmsGallerySearchParameters.class);
    private List<String> m_categories;
    private CmsGallerySearchTimeRange m_dateCreatedTimeRange;
    private CmsGallerySearchTimeRange m_dateLastModifiedTimeRange;
    private Set<CmsUUID> m_excludedFunctions;
    private List<String> m_folders;
    private List<String> m_foldersToSearchIn;
    private boolean m_forceEmptyResult;
    private CmsFunctionAvailability m_functionAvailability;
    private List<String> m_galleries;
    private boolean m_ignoreSearchExclude;
    private Set<CmsUUID> m_includedFunctions;
    private boolean m_includeExpired;
    private String m_locale;
    private int m_matchesPerPage = 10;
    private String m_referencePath;
    private List<String> m_resourceTypes;
    private int m_resultPage = 1;
    private CmsGallerySearchScope m_scope;
    private CmsGallerySortParam m_sortOrder;
    private String m_templateCompatibility;
    private String m_words;

    public List<String> getCategories() {
        return this.m_categories;
    }

    public CmsGallerySearchTimeRange getDateCreatedRange() {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateCreatedTimeRange;
    }

    public CmsGallerySearchTimeRange getDateLastModifiedRange() {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange();
        }
        return this.m_dateLastModifiedTimeRange;
    }

    public Set<CmsUUID> getExcludedFunctions() {
        return this.m_excludedFunctions;
    }

    public List<String> getFolders() {
        return this.m_folders;
    }

    public List<String> getGalleries() {
        return this.m_galleries;
    }

    public Set<CmsUUID> getIncludedFunctions() {
        return this.m_includedFunctions;
    }

    public String getLocale() {
        if (this.m_locale == null) {
            this.m_locale = CmsLocaleManager.getDefaultLocale().toString();
        }
        return this.m_locale;
    }

    public int getMatchesPerPage() {
        return this.m_matchesPerPage;
    }

    public CmsSolrQuery getQuery(CmsObject cms) {
        CmsSolrQuery query = new CmsSolrQuery();
        query.setCategories(this.m_categories);
        query.addFilterQuery(new String[]{CmsSearchUtil.getDateCreatedTimeRangeFilterQuery("created", this.getDateCreatedRange().m_startTime, this.getDateCreatedRange().m_endTime)});
        query.addFilterQuery(new String[]{CmsSearchUtil.getDateCreatedTimeRangeFilterQuery("lastmodified", this.getDateLastModifiedRange().m_startTime, this.getDateLastModifiedRange().m_endTime)});
        this.m_foldersToSearchIn = new ArrayList<String>();
        this.addFoldersToSearchIn(this.m_folders);
        this.addFoldersToSearchIn(this.m_galleries);
        this.setSearchFolders(cms);
        query.addFilterQuery("parent-folders", new ArrayList<String>(this.m_foldersToSearchIn), false, true);
        if (!this.m_ignoreSearchExclude) {
            query.addFilterQuery("-search_exclude", Arrays.asList("all", "gallery"), false, true);
        }
        query.setRows(this.m_matchesPerPage);
        if (null != this.m_resourceTypes) {
            ArrayList<String> resourceTypes = new ArrayList<String>(this.m_resourceTypes);
            if (this.m_resourceTypes.contains("function_config") && !this.m_resourceTypes.contains("function")) {
                resourceTypes.add("function");
            }
            query.setResourceTypes(resourceTypes);
        }
        query.setStart((this.m_resultPage - 1) * this.m_matchesPerPage);
        if (null != this.m_locale) {
            Locale l = CmsLocaleManager.getLocale(this.m_locale);
            ArrayList<Locale> locales = new ArrayList<Locale>(3);
            locales.add(l);
            if (!l.getVariant().isEmpty()) {
                locales.add(new Locale(l.getLanguage(), l.getCountry()));
            }
            if (!l.getCountry().isEmpty()) {
                locales.add(new Locale(l.getLanguage()));
            }
            query.setLocales(locales);
        }
        if (null != this.m_words) {
            query.setQuery(this.m_words);
        }
        query.setSort(this.getSort().getFirst(), this.getSort().getSecond());
        query.addFilterQuery(new String[]{"{!collapse field=id sort='instancedate_dt asc'}"});
        query.setFields(CmsGallerySearchResult.getRequiredSolrFields());
        if (this.m_functionAvailability != null && this.m_functionAvailability.isDefined()) {
            String idClause;
            String notFunction = "(*:* AND -type:(function OR function_config))";
            Collection<CmsUUID> whitelist = this.m_functionAvailability.getWhitelist();
            ArrayList<CmsUUID> blacklist = new ArrayList<CmsUUID>(this.m_functionAvailability.getBlacklist());
            CmsUUID dummyId = CmsUUID.getNullUUID();
            blacklist.add(dummyId);
            if (whitelist != null) {
                whitelist = new ArrayList<CmsUUID>(whitelist);
                whitelist.add(dummyId);
                String whitelistIdCondition = whitelist.stream().map(id -> id.toString()).collect(Collectors.joining(" OR "));
                idClause = "id:(" + whitelistIdCondition + ")";
            } else {
                idClause = "*:* AND -id:(" + blacklist.stream().map(id -> id.toString()).collect(Collectors.joining(" OR ")) + ") ";
            }
            String functionFilter = "(" + notFunction + " OR (" + idClause + "))";
            query.addFilterQuery(new String[]{functionFilter});
        }
        if (this.m_resourceTypes != null && this.m_resourceTypes.contains("function_config")) {
            if (this.m_excludedFunctions != null && this.m_excludedFunctions.size() > 0) {
                ArrayList<CmsUUID> excludedFunctions = new ArrayList<CmsUUID>(this.m_excludedFunctions);
                Collections.sort(excludedFunctions);
                String orList = Joiner.on((String)" OR ").join(excludedFunctions);
                String filter = "*:* AND -id:(" + orList + ")";
                query.addFilterQuery(new String[]{filter});
            }
            if (this.m_includedFunctions != null) {
                ArrayList<CmsUUID> includedFunctions = new ArrayList<CmsUUID>(this.m_includedFunctions);
                Collections.sort(includedFunctions);
                ArrayList<Object> conditions = new ArrayList<Object>();
                String notFunction = "(*:* AND -type:(function OR function_config))";
                conditions.add(notFunction);
                for (CmsUUID id2 : includedFunctions) {
                    conditions.add("id:" + String.valueOf(id2));
                }
                String includedFunctionsFilter = Joiner.on((String)" OR ").join(conditions);
                query.addFilterQuery(new String[]{includedFunctionsFilter});
            }
        }
        if (this.m_templateCompatibility != null) {
            if (this.m_templateCompatibility.matches("^[0-9a-zA-Z_]+$")) {
                String fieldName = "template.compatibility_prop";
                query.addFilterQuery(new String[]{"(*:* NOT " + fieldName + ":*) OR " + fieldName + ":" + this.m_templateCompatibility});
            } else {
                LOG.warn((Object)("Invalid template compatibility value: " + this.m_templateCompatibility + ". Must only contain digits, letters (a-z) or underscores."));
            }
        }
        if (this.m_includeExpired) {
            query.removeExpiration();
        }
        return query;
    }

    public String getReferencePath() {
        return this.m_referencePath;
    }

    public List<String> getResourceTypes() {
        return this.m_resourceTypes;
    }

    public int getResultPage() {
        return this.m_resultPage;
    }

    public CmsGallerySearchScope getScope() {
        if (this.m_scope == null) {
            return OpenCms.getWorkplaceManager().getGalleryDefaultScope();
        }
        return this.m_scope;
    }

    public String getSearchWords() {
        return this.m_words;
    }

    public CmsGallerySortParam getSortOrder() {
        if (this.m_sortOrder == null) {
            this.m_sortOrder = CmsGallerySortParam.DEFAULT;
        }
        return this.m_sortOrder;
    }

    public String getTemplateCompatibility() {
        return this.m_templateCompatibility;
    }

    public boolean isForceEmptyResult() {
        return this.m_forceEmptyResult;
    }

    public boolean isIgnoreSearchExclude() {
        return this.m_ignoreSearchExclude;
    }

    public boolean isIncludeExpired() {
        return this.m_includeExpired;
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setDateCreatedTimeRange(long startTime, long endTime) {
        if (this.m_dateCreatedTimeRange == null) {
            this.m_dateCreatedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setDateLastModifiedTimeRange(long startTime, long endTime) {
        if (this.m_dateLastModifiedTimeRange == null) {
            this.m_dateLastModifiedTimeRange = new CmsGallerySearchTimeRange(startTime, endTime);
        }
    }

    public void setExcludedFunctions(Set<CmsUUID> excludedFunctions) {
        this.m_excludedFunctions = excludedFunctions;
    }

    public void setFolders(List<String> folders) {
        this.m_folders = folders;
    }

    public void setForceEmptyResult(boolean forceEmptyResult) {
        this.m_forceEmptyResult = forceEmptyResult;
    }

    public void setFunctionAvailability(CmsFunctionAvailability dynamicFunctionAvailability) {
        this.m_functionAvailability = dynamicFunctionAvailability;
    }

    public void setGalleries(List<String> galleries) {
        this.m_galleries = galleries;
    }

    public void setIgnoreSearchExclude(boolean excludeForPageEditor) {
        this.m_ignoreSearchExclude = excludeForPageEditor;
    }

    public void setIncludedFunctions(Set<CmsUUID> includedFunctions) {
        this.m_includedFunctions = includedFunctions;
    }

    public void setIncludeExpired(boolean includeExpired) {
        this.m_includeExpired = includeExpired;
    }

    public void setMatchesPerPage(int matchesPerPage) {
        this.m_matchesPerPage = matchesPerPage;
    }

    public void setReferencePath(String referencePath) {
        this.m_referencePath = referencePath;
    }

    public void setResourceTypes(List<String> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setResultPage(int resultPage) {
        this.m_resultPage = resultPage;
    }

    public void setScope(CmsGallerySearchScope scope) {
        this.m_scope = scope;
    }

    public void setSearchLocale(String locale) {
        this.m_locale = locale;
    }

    public void setSearchWords(String words) {
        this.m_words = words;
    }

    public void setSortOrder(CmsGallerySortParam sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public void setTemplateCompatibility(String compatibility) {
        this.m_templateCompatibility = compatibility;
    }

    /*
     * WARNING - void declaration
     */
    private void addFoldersToSearchIn(List<String> folders) {
        if (null == folders) {
            return;
        }
        for (String string : folders) {
            void var3_3;
            if (!CmsResource.isFolder(string)) {
                String string2 = string + "/";
            }
            this.m_foldersToSearchIn.add((String)var3_3);
        }
    }

    private boolean containsFunctionType(List<String> resourceTypes) {
        if (resourceTypes.contains("function")) {
            return true;
        }
        return resourceTypes.contains("function_config");
    }

    private CmsPair<String, SolrQuery.ORDER> getSort() {
        String sortTitle = CmsSearchFieldConfiguration.getLocaleExtendedName("disptitle", this.getLocale()) + "_sort";
        switch (this.getSortOrder()) {
            case dateCreated_asc: {
                return CmsPair.create("created", SolrQuery.ORDER.asc);
            }
            case dateCreated_desc: {
                return CmsPair.create("created", SolrQuery.ORDER.desc);
            }
            case dateExpired_asc: {
                return CmsPair.create("expired", SolrQuery.ORDER.asc);
            }
            case dateExpired_desc: {
                return CmsPair.create("expired", SolrQuery.ORDER.desc);
            }
            case dateLastModified_asc: {
                return CmsPair.create("lastmodified", SolrQuery.ORDER.asc);
            }
            case dateLastModified_desc: {
                return CmsPair.create("lastmodified", SolrQuery.ORDER.desc);
            }
            case dateReleased_asc: {
                return CmsPair.create("released", SolrQuery.ORDER.asc);
            }
            case dateReleased_desc: {
                return CmsPair.create("released", SolrQuery.ORDER.desc);
            }
            case length_asc: {
                return CmsPair.create("size", SolrQuery.ORDER.asc);
            }
            case length_desc: {
                return CmsPair.create("size", SolrQuery.ORDER.desc);
            }
            case path_asc: {
                return CmsPair.create("path", SolrQuery.ORDER.asc);
            }
            case path_desc: {
                return CmsPair.create("path", SolrQuery.ORDER.desc);
            }
            case score: {
                return CmsPair.create("score", SolrQuery.ORDER.desc);
            }
            case state_asc: {
                return CmsPair.create("state", SolrQuery.ORDER.asc);
            }
            case state_desc: {
                return CmsPair.create("state", SolrQuery.ORDER.desc);
            }
            case title_asc: {
                return CmsPair.create(sortTitle, SolrQuery.ORDER.asc);
            }
            case title_desc: {
                return CmsPair.create(sortTitle, SolrQuery.ORDER.desc);
            }
            case type_asc: {
                return CmsPair.create("type", SolrQuery.ORDER.asc);
            }
            case type_desc: {
                return CmsPair.create("type", SolrQuery.ORDER.desc);
            }
            case userCreated_asc: {
                return CmsPair.create("userCreated", SolrQuery.ORDER.asc);
            }
            case userCreated_desc: {
                return CmsPair.create("userCreated", SolrQuery.ORDER.desc);
            }
            case userLastModified_asc: {
                return CmsPair.create("userLastModified", SolrQuery.ORDER.asc);
            }
            case userLastModified_desc: {
                return CmsPair.create("userLastModified", SolrQuery.ORDER.desc);
            }
        }
        return CmsPair.create(sortTitle, SolrQuery.ORDER.asc);
    }

    private void setSearchFolders(CmsObject obj) {
        if (this.m_foldersToSearchIn.isEmpty()) {
            this.setSearchScopeFilter(obj);
        }
    }

    private void setSearchScopeFilter(CmsObject cms) {
        List<String> searchRoots = CmsSearchUtil.computeScopeFolders(cms, this);
        if (null != this.getResourceTypes() && this.containsFunctionType(this.getResourceTypes())) {
            searchRoots.add("/system/modules/");
        }
        this.addFoldersToSearchIn(searchRoots);
    }

    class CmsGallerySearchTimeRange {
        long m_endTime;
        long m_startTime;

        public CmsGallerySearchTimeRange() {
            this.m_startTime = Long.MIN_VALUE;
            this.m_endTime = Long.MAX_VALUE;
        }

        public CmsGallerySearchTimeRange(long startTime, long endTime) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }

        public long getEndTime() {
            return this.m_endTime;
        }

        public long getStartTime() {
            return this.m_startTime;
        }
    }

    public static enum CmsGallerySortParam {
        dateCreated_asc,
        dateCreated_desc,
        dateExpired_asc,
        dateExpired_desc,
        dateLastModified_asc,
        dateLastModified_desc,
        dateReleased_asc,
        dateReleased_desc,
        length_asc,
        length_desc,
        path_asc,
        path_desc,
        score,
        state_asc,
        state_desc,
        title_asc,
        title_desc,
        type_asc,
        type_desc,
        userCreated_asc,
        userCreated_desc,
        userLastModified_asc,
        userLastModified_desc;

        public static final CmsGallerySortParam DEFAULT;

        static {
            DEFAULT = title_asc;
        }
    }
}

