/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.util.CmsGeoUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsGeoMappingConfiguration;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsGeoCoordinateFieldMapping
implements I_CmsSearchFieldMapping {
    private static final Log LOG = CmsLog.getLog(CmsGeoCoordinateFieldMapping.class);
    private static final long serialVersionUID = 1L;
    public static final int MAX_DEPTH = 2;
    private CmsGeoMappingConfiguration m_config;

    public CmsGeoCoordinateFieldMapping(CmsGeoMappingConfiguration config) {
        this.m_config = config;
    }

    @Override
    public String getDefaultValue() {
        return "0.000000,0.000000";
    }

    @Override
    public String getParam() {
        return "";
    }

    @Override
    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String result = this.getStringValue(0, this.m_config, cms, res, extractionResult);
        return result;
    }

    public String getStringValue(int depth, CmsGeoMappingConfiguration mappingConfig, CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult) {
        block9: for (CmsGeoMappingConfiguration.Entry entry : mappingConfig.getEntries()) {
            try {
                switch (entry.getType()) {
                    case field: {
                        String value = this.findFirstCoordinatesValue(extractionResult, entry.getValue());
                        String coord = CmsGeoUtil.parseCoordinates(value);
                        if (coord == null) break;
                        return coord;
                    }
                    case link: {
                        if (depth >= 2) {
                            LOG.error((Object)("maximum depth exceeded for linked geo-coordinate mapping in " + res.getRootPath()));
                            return null;
                        }
                        String xpath = CmsXmlUtils.createXpath(entry.getValue(), 1);
                        HashSet<String> paths = new HashSet<String>();
                        for (Locale locale : extractionResult.getLocales()) {
                            String path = extractionResult.getContentItems(locale).get(xpath);
                            if (path == null) continue;
                            paths.add(path);
                        }
                        I_CmsSearchIndex index = OpenCms.getSearchManager().getIndex(cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline");
                        for (String path : paths) {
                            try {
                                String linkResult;
                                I_CmsXmlContentHandler linkContentHandler;
                                CmsGeoMappingConfiguration linkMappingConfig;
                                A_CmsXmlDocument[] contentHolder;
                                CmsResource linkedResource = cms.readResource(path);
                                CmsExtractionResult linkExtractionResult = CmsSolrDocumentXmlContent.extractXmlContent(cms, linkedResource, index, null, new HashSet<CmsUUID>(), arg_0 -> CmsGeoCoordinateFieldMapping.lambda$getStringValue$0(contentHolder = new A_CmsXmlDocument[]{null}, arg_0));
                                if (linkExtractionResult == null || contentHolder[0] == null || (linkMappingConfig = (linkContentHandler = contentHolder[0].getContentDefinition().getContentHandler()).getGeoMappingConfiguration()) == null || (linkResult = this.getStringValue(depth + 1, linkMappingConfig, cms, contentHolder[0].getFile(), linkExtractionResult)) == null) continue;
                                return linkResult;
                            }
                            catch (CmsVfsResourceNotFoundException e) {
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        continue block9;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public CmsSearchFieldMappingType getType() {
        return CmsSearchFieldMappingType.ITEM;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
    }

    @Override
    public void setParam(String param) {
    }

    @Override
    public void setType(CmsSearchFieldMappingType type) {
    }

    @Override
    public void setType(String type) {
    }

    private String findFirstCoordinatesValue(I_CmsExtractionResult extractionResult, String xpath) {
        xpath = CmsXmlUtils.createXpath(xpath, 1);
        String value = extractionResult.getContentItems().get(xpath);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            for (Locale locale : extractionResult.getLocales()) {
                String val = extractionResult.getContentItems(locale).get(xpath);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(val)) continue;
                return val;
            }
        }
        return value;
    }

    private static /* synthetic */ void lambda$getStringValue$0(A_CmsXmlDocument[] contentHolder, A_CmsXmlDocument content) {
        contentHolder[0] = content;
    }
}

