/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

public class CmsSearchSimilarity
extends Similarity {
    private static final double LOG10 = Math.log(10.0);
    private final BM25Similarity m_bm25Sim = new BM25Similarity();

    public final long computeNorm(FieldInvertState state) {
        int numTerms;
        int n = numTerms = this.m_bm25Sim.getDiscountOverlaps() ? state.getLength() - state.getNumOverlap() : state.getLength();
        if (state.getIndexCreatedVersionMajor() >= 7) {
            return SmallFloat.intToByte4((int)numTerms);
        }
        return SmallFloat.floatToByte315((float)this.lengthNorm(state, numTerms));
    }

    public boolean getDiscountOverlaps() {
        return this.m_bm25Sim.getDiscountOverlaps();
    }

    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return this.m_bm25Sim.scorer(boost, collectionStats, termStats);
    }

    private float lengthNorm(FieldInvertState state, int numTerms) {
        if (state.getName().equals("content")) {
            numTerms = state.getLength() - state.getNumOverlap();
            return (float)(3.0 / (Math.log(1000 + numTerms) / LOG10));
        }
        return (float)(1.0 / Math.sqrt(numTerms));
    }
}

