/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.Date;
import java.util.List;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsResource;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.util.CmsUUID;

public class CmsSearchResource
extends CmsResource {
    private static final long serialVersionUID = -323110688331457211L;
    private I_CmsSearchDocument m_doc;

    public CmsSearchResource(CmsResource resource, I_CmsSearchDocument doc) {
        this(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.getFlags(), resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getSiblingCount(), resource.getLength(), resource.getDateContent(), resource.getVersion(), doc);
    }

    public CmsSearchResource(CmsUUID structureId, CmsUUID resourceId, String path, int type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int linkCount, int length, long dateContent, int version, I_CmsSearchDocument doc) {
        super(structureId, resourceId, path, type, false, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, linkCount, length, dateContent, version);
        this.m_doc = doc;
    }

    public Date getDateField(String fieldName) {
        return this.m_doc.getFieldValueAsDate(fieldName);
    }

    public I_CmsSearchDocument getDocument() {
        return this.m_doc;
    }

    public String getField(String fieldName) {
        return this.m_doc.getFieldValueAsString(fieldName);
    }

    public List<String> getMultivaluedField(String fieldName) {
        return this.m_doc.getMultivaluedFieldAsStringList(fieldName);
    }

    public int getScore(float maxScore) {
        return Math.round(this.m_doc.getScore() / maxScore * 100.0f);
    }
}

