/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.util.CmsStringUtil;

public class CmsHistoryClearJob
implements I_CmsScheduledJob {
    public static final String PARAM_CLEAR_DELETED_PATHS = "clearDeletedPaths";
    public static final String PARAM_CLEAR_DELETED_TYPES = "clearDeletedTypes";
    public static final String PARAM_CLEARDELETED = "clearDeleted";
    public static final String PARAM_KEEPTIMERANGE = "keepTimeRange";
    public static final String PARAM_KEEPVERSIONS = "keepVersions";
    private static final Log LOG = CmsLog.getLog(CmsHistoryClearJob.class);

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        int keepDeletedVersions;
        int keepVersions = Integer.parseInt(parameters.get(PARAM_KEEPVERSIONS));
        boolean clearDeleted = Boolean.valueOf(parameters.get(PARAM_CLEARDELETED));
        String keepTimeRangeStr = parameters.get(PARAM_KEEPTIMERANGE);
        int keepTimeRange = -1;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(keepTimeRangeStr)) {
            keepTimeRange = Integer.parseInt(keepTimeRangeStr);
        }
        String clearDeletedTypesStr = parameters.get(PARAM_CLEAR_DELETED_TYPES);
        HashSet<Integer> clearDeletedTypes = new HashSet<Integer>();
        if (clearDeletedTypesStr != null) {
            for (String token : clearDeletedTypesStr.split(",")) {
                String typeName = token.trim();
                if (!OpenCms.getResourceManager().hasResourceType(typeName)) continue;
                try {
                    clearDeletedTypes.add(OpenCms.getResourceManager().getResourceType(typeName).getTypeId());
                }
                catch (CmsLoaderException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        String clearDeletedPathsStr = parameters.get(PARAM_CLEAR_DELETED_PATHS);
        ArrayList<String> clearDeletedPaths = new ArrayList<String>();
        if (clearDeletedPathsStr != null) {
            for (String token : clearDeletedPathsStr.split(",")) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(token = token.trim())) continue;
                clearDeletedPaths.add(token);
            }
        }
        long timeDeleted = -1L;
        if (clearDeleted) {
            keepDeletedVersions = 1;
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(6, keepTimeRange * -1);
            timeDeleted = cal.getTimeInMillis();
        } else {
            keepDeletedVersions = -1;
        }
        CmsLogReport report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsHistoryClearJob.class);
        cms.deleteHistoricalVersions(keepVersions, keepDeletedVersions, timeDeleted, res -> {
            boolean delete = true;
            if (clearDeletedTypesStr != null) {
                delete &= clearDeletedTypes.contains(res.getTypeId());
            }
            if (clearDeletedPathsStr != null) {
                delete &= clearDeletedPaths.stream().anyMatch(prefix -> CmsStringUtil.isPrefixPath(prefix, res.getRootPath()));
            }
            return delete;
        }, report);
        return null;
    }
}

