/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsResourceManager;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishManager;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.jobs.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsDeleteExpiredResourcesJob
implements I_CmsScheduledJob {
    public static final String PARAM_EXPIRATIONSDAYS = "expirationdays";
    public static final String PARAM_RESOURCETYPES = "resourcetypes";
    public static final String PARAM_FOLDER = "folder";
    private static final long MILLIS_PER_DAY = 86400000L;
    public static final String PROPERTY_VALUE_DELETE_EXPIRED_NEVER = "never";
    public static final String PROPERTY_VALUE_DELETE_EXPIRED_NONE = "none";

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        if (OpenCms.getRunLevel() == 4) {
            long currenttime = System.currentTimeMillis();
            int expirationdays = 30;
            String expirationdaysparam = parameters.get(PARAM_EXPIRATIONSDAYS);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(expirationdaysparam)) {
                try {
                    expirationdays = Integer.parseInt(expirationdaysparam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String resTypes = parameters.get(PARAM_RESOURCETYPES);
            String[] resTypesArr = null;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resTypes)) {
                resTypesArr = CmsStringUtil.splitAsArray(resTypes, ',');
            }
            String[] topFoldersArr = new String[]{"/"};
            String topfolders = parameters.get(PARAM_FOLDER);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(topfolders)) {
                topFoldersArr = CmsStringUtil.splitAsArray(topfolders, ',');
            }
            CmsProject project = cms.createTempfileProject();
            cms.getRequestContext().setCurrentProject(project);
            CmsLogReport report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsDeleteExpiredResourcesJob.class);
            report.println(Messages.get().container("RPT_DELETE_EXPIRED_START_0"), 2);
            List<CmsResource> resources = Collections.emptyList();
            CmsResourceFilter filter = CmsResourceFilter.ALL.addExcludeState(CmsResourceState.STATE_DELETED);
            filter = filter.addRequireExpireBefore(currenttime);
            int changedFiles = 0;
            if (resTypesArr != null) {
                CmsResourceManager resManager = OpenCms.getResourceManager();
                for (int i = resTypesArr.length - 1; i >= 0; --i) {
                    I_CmsResourceType type = resManager.getResourceType(resTypesArr[i]);
                    filter = filter.addRequireType(type.getTypeId());
                    for (int j = topFoldersArr.length - 1; j >= 0; --j) {
                        resources = cms.readResources(topFoldersArr[j], filter, true);
                        changedFiles += this.deleteExpiredResources(cms, report, resources, expirationdays, currenttime);
                    }
                }
            } else {
                filter = filter.addRequireFile();
                for (int j = topFoldersArr.length - 1; j >= 0; --j) {
                    resources = cms.readResources(topFoldersArr[j], filter, true);
                    changedFiles += this.deleteExpiredResources(cms, report, resources, expirationdays, currenttime);
                }
            }
            if (changedFiles > 0) {
                CmsPublishManager publishManager = OpenCms.getPublishManager();
                publishManager.publishProject(cms, report);
                publishManager.waitWhileRunning();
            }
            report.println(Messages.get().container("RPT_DELETE_EXPIRED_END_0"), 2);
        }
        return null;
    }

    private int deleteExpiredResources(CmsObject cms, I_CmsReport report, List<CmsResource> resources, int expirationdays, long currenttime) {
        int result = 0;
        for (CmsResource resource : resources) {
            String resourcePath = cms.getRequestContext().removeSiteRoot(resource.getRootPath());
            report.print(Messages.get().container("RPT_DELETE_EXPIRED_PROCESSING_1", new String[]{resourcePath}), 0);
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            if (resource.getState() == CmsResourceState.STATE_UNCHANGED) {
                long expirationdate = resource.getDateExpired();
                int expirationDaysPropertyOverride = expirationdays;
                try {
                    CmsProperty property = cms.readPropertyObject(resource, "delete.expired", true);
                    String propertyValue = property.getValue();
                    if (!property.isNullProperty()) {
                        if (PROPERTY_VALUE_DELETE_EXPIRED_NEVER.equals(propertyValue) || PROPERTY_VALUE_DELETE_EXPIRED_NONE.equals(propertyValue) || Boolean.FALSE.toString().equals(propertyValue)) {
                            report.println(Messages.get().container("RPT_DELETE_EXPIRED_PROPERTY_NEVER_0"), 3);
                            continue;
                        }
                        if (!Boolean.TRUE.toString().equals(propertyValue)) {
                            expirationDaysPropertyOverride = Integer.parseInt(propertyValue);
                        }
                    }
                    if (expirationdate != Long.MAX_VALUE && currenttime - expirationdate > (long)expirationDaysPropertyOverride * 86400000L) {
                        CmsLock lock = cms.getLock(resource);
                        if (lock.isNullLock()) {
                            cms.lockResource(resourcePath);
                        } else if (!lock.getUserId().equals(cms.getRequestContext().getCurrentUser().getId())) {
                            report.println(Messages.get().container("RPT_DELETE_EXPIRED_LOCKED_0"), 1);
                            continue;
                        }
                        cms.deleteResource(resourcePath, CmsResource.DELETE_PRESERVE_SIBLINGS);
                        ++result;
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                        continue;
                    }
                    report.println(Messages.get().container("RPT_DELETE_EXPIRED_NOT_EXPIRED_1", new Integer[]{expirationDaysPropertyOverride}));
                }
                catch (Exception e) {
                    report.println(Messages.get().container("RPT_DELETE_EXPIRED_FAILED_1", new String[]{CmsException.getStackTraceAsString(e)}), 5);
                }
                continue;
            }
            report.println(Messages.get().container("RPT_DELETE_EXPIRED_UNPUBLISHED_0"));
        }
        return result;
    }
}

