/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.rmi;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.CmsShellCommandException;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.OpenCms;
import org.opencms.rmi.CmsShellCommandResult;
import org.opencms.rmi.I_CmsRemoteShell;
import org.opencms.util.CmsStringUtil;

public class CmsRemoteShell
extends UnicastRemoteObject
implements I_CmsRemoteShell {
    private static final Log LOG = CmsLog.getLog(CmsRemoteShell.class);
    private static final long serialVersionUID = -243325251951003282L;
    private static InstanceStore m_instanceStore = new InstanceStore();
    private ByteArrayOutputStream m_baos = new ByteArrayOutputStream();
    private String m_id = RandomStringUtils.randomAlphanumeric((int)8);
    private PrintStream m_out;
    private CmsShell m_shell;

    public CmsRemoteShell(String additionalCommandsNames, int port) throws CmsException, RemoteException {
        super(port);
        ArrayList<I_CmsShellCommands> additionalCommands = new ArrayList<I_CmsShellCommands>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(additionalCommandsNames)) {
            String[] classNames;
            for (String className : classNames = additionalCommandsNames.split(",")) {
                try {
                    className = className.trim();
                    Class<?> commandsCls = Class.forName(className);
                    if (I_CmsShellCommands.class.isAssignableFrom(commandsCls)) {
                        additionalCommands.add((I_CmsShellCommands)commandsCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        LOG.info((Object)("Class " + className + " has been loaded and added to additional commands."));
                        continue;
                    }
                    LOG.error((Object)("Error: Class " + className + " does not implement I_CmsShellCommands"));
                }
                catch (ClassNotFoundException e) {
                    String errMsg = "Error: Could not find the class " + className;
                    LOG.error((Object)errMsg, (Throwable)e);
                    throw new IllegalArgumentException(errMsg, e);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    String errMsg = "Error instantiating the class " + className + ". " + e.getLocalizedMessage();
                    LOG.error((Object)errMsg, (Throwable)e);
                    throw new IllegalArgumentException(errMsg, e);
                }
            }
        }
        CmsObject cms = OpenCms.initCmsObject("Guest");
        this.m_out = new PrintStream(this.m_baos, true);
        this.m_shell = new CmsShell(cms, "${user}@${project}:${siteroot}|${uri}>", additionalCommands, this.m_out, this.m_out);
        m_instanceStore.add(this);
    }

    public static void unregisterAll() {
        m_instanceStore.removeAll();
    }

    @Override
    public void end() {
        m_instanceStore.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsShellCommandResult executeCommand(String cmd, List<String> params) {
        LOG.debug((Object)(this.m_id + " executing " + cmd + " " + String.valueOf(params)));
        CmsShellCommandResult result = new CmsShellCommandResult();
        this.m_baos.reset();
        boolean hasError = false;
        try {
            CmsShell.pushShell(this.m_shell);
            this.m_shell.executeCommand(cmd, params);
        }
        catch (CmsShellCommandException e) {
            hasError = true;
            LOG.warn((Object)(this.m_id + " " + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            CmsShell.popShell();
            this.m_out.flush();
        }
        result.setExitCalled(this.m_shell.isExitCalled());
        result.setHasError(hasError |= this.m_shell.hasReportError());
        result.setErrorCode(this.m_shell.getErrorCode());
        result.setPrompt(this.m_shell.getPrompt());
        result.setEcho(this.m_shell.hasEcho());
        try {
            String outputString = new String(this.m_baos.toByteArray(), "UTF-8");
            result.setOutput(outputString);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getPrompt() {
        return this.m_shell.getPrompt();
    }

    static class InstanceStore {
        private List<CmsRemoteShell> m_instances = Lists.newArrayList();

        InstanceStore() {
        }

        public synchronized void add(CmsRemoteShell shell) {
            this.m_instances.add(shell);
        }

        public synchronized void remove(CmsRemoteShell cmsRemoteShell) {
            try {
                UnicastRemoteObject.unexportObject(cmsRemoteShell, true);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_instances.remove(cmsRemoteShell);
        }

        public synchronized void removeAll() {
            for (CmsRemoteShell shell : this.m_instances) {
                try {
                    UnicastRemoteObject.unexportObject(shell, true);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_instances.clear();
        }
    }
}

