/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.Date;

public class CmsRepositoryLockInfo {
    public static final String SCOPE_EXCLUSIVE = "exclusive";
    public static final String DEFAULT_SCOPE = "exclusive";
    public static final int TIMEOUT_INFINITE_VALUE = -1;
    public static final String TYPE_WRITE = "write";
    public static final String DEFAULT_TYPE = "write";
    public static final int DEPTH_INFINITY_VALUE = 3;
    public static final String SCOPE_SHARED = "shared";
    private Date m_creationDate = new Date();
    private int m_depth;
    private long m_expiresAt = -1L;
    private String m_owner = "";
    private String m_path = "/";
    private String m_scope = "exclusive";
    private String m_type = "write";
    private String m_username = "";

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public long getExpiresAt() {
        return this.m_expiresAt;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getScope() {
        return this.m_scope;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUsername() {
        return this.m_username;
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.m_expiresAt;
    }

    public boolean isExclusive() {
        return this.m_scope.equals("exclusive");
    }

    public void setDepth(int depth) {
        this.m_depth = depth;
    }

    public void setExpiresAt(long expiresAt) {
        this.m_expiresAt = expiresAt;
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setScope(String scope) {
        this.m_scope = scope;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String toString() {
        String result = "Type:" + this.m_type + "\n";
        result = result + "Scope:" + this.m_scope + "\n";
        result = result + "Depth:" + this.m_depth + "\n";
        result = result + "Owner:" + this.m_owner + "\n";
        result = result + "Expiration:" + String.valueOf(new Date(this.m_expiresAt)) + "\n";
        return result;
    }
}

