/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReport;
import org.opencms.report.CmsClassicJavascriptReportUpdateFormatter;
import org.opencms.report.CmsLogReport;
import org.opencms.report.CmsReportFormatType;
import org.opencms.report.CmsReportUpdateItem;
import org.opencms.report.I_CmsReportUpdateFormatter;

public class CmsWorkplaceReport
extends A_CmsReport {
    public static final int FORMAT_NEWLINE = -1;
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceReport.class);
    private List<Object> m_content;
    private int m_indexNext;
    private CmsLogReport m_logReport;
    private boolean m_transient;

    public CmsWorkplaceReport(Locale locale, String siteRoot, boolean isTransient, Object logChannel) {
        this.init(locale, siteRoot);
        if (logChannel != null) {
            this.m_logReport = new CmsLogReport(locale, logChannel);
        }
        this.m_content = new ArrayList<Object>(256);
        this.m_transient = isTransient;
    }

    public CmsWorkplaceReport(Locale locale, String siteRoot, Object logChannel) {
        this(locale, siteRoot, false, logChannel);
    }

    @Override
    public synchronized String getReportUpdate() {
        return this.getReportUpdate(new CmsClassicJavascriptReportUpdateFormatter(this.getLocale()));
    }

    @Override
    public synchronized String getReportUpdate(I_CmsReportUpdateFormatter formatter) {
        int indexEnd = this.m_content.size();
        ArrayList itemsToFormat = Lists.newArrayList();
        for (int i = this.m_indexNext; i < indexEnd; ++i) {
            int pos = this.m_transient ? 0 : i;
            Object obj = this.m_content.get(pos);
            CmsReportUpdateItem entry = (CmsReportUpdateItem)obj;
            itemsToFormat.add(entry);
            if (!this.m_transient) continue;
            this.m_content.remove(this.m_indexNext);
        }
        String result = formatter.formatReportUpdate(itemsToFormat);
        this.m_indexNext = this.m_transient ? 0 : indexEnd;
        return result;
    }

    @Override
    public synchronized void print(String value, int format) {
        if (this.m_logReport != null) {
            this.m_logReport.print(value, format);
        }
        if (format == 5) {
            this.addError(value);
        } else if (format == 1) {
            this.addWarning(value);
        }
        CmsReportUpdateItem message = new CmsReportUpdateItem(CmsReportFormatType.byId(format), value);
        this.m_content.add(message);
        this.setLastEntryTime(System.currentTimeMillis());
    }

    @Override
    public void println() {
        if (this.m_logReport != null) {
            this.m_logReport.println();
        }
        this.print("", -1);
    }

    @Override
    public synchronized void println(Throwable t) {
        if (this.m_logReport != null) {
            this.m_logReport.println(t);
        }
        this.addError(t.getMessage());
        this.m_content.add(new CmsReportUpdateItem(CmsReportFormatType.fmtException, t));
        this.setLastEntryTime(System.currentTimeMillis());
    }

    public void rewind() {
        this.m_indexNext = 0;
    }
}

