/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.CmsReportFormatType;
import org.opencms.report.CmsReportUpdateItem;
import org.opencms.report.I_CmsReportUpdateFormatter;
import org.opencms.report.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsClassicJavascriptReportUpdateFormatter
implements I_CmsReportUpdateFormatter {
    private static final Log LOG = CmsLog.getLog(CmsClassicJavascriptReportUpdateFormatter.class);
    private Locale m_locale;

    public CmsClassicJavascriptReportUpdateFormatter(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public String formatReportUpdate(List<CmsReportUpdateItem> updateItem) {
        StringBuffer buffer = new StringBuffer();
        for (CmsReportUpdateItem item : updateItem) {
            try {
                buffer.append(this.formatItem(item));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return buffer.toString();
    }

    private String formatException(Throwable throwable) {
        StringBuffer buf = new StringBuffer();
        buf.append("aT('");
        buf.append(Messages.get().getBundle(this.m_locale).key("RPT_EXCEPTION_0"));
        String exception = CmsEncoder.escapeXml(CmsException.getStackTraceAsString(throwable));
        StringBuffer excBuffer = new StringBuffer(exception.length() + 50);
        StringTokenizer tok = new StringTokenizer(exception, "\r\n");
        while (tok.hasMoreTokens()) {
            excBuffer.append(tok.nextToken());
            excBuffer.append("<br>");
        }
        buf.append(CmsStringUtil.escapeJavaScript(excBuffer.toString()));
        buf.append("'); ");
        return buf.toString();
    }

    private String formatItem(CmsReportUpdateItem updateItem) {
        StringBuffer buf = new StringBuffer();
        CmsReportFormatType format = updateItem.getType();
        if (format == CmsReportFormatType.fmtException) {
            return this.formatException((Throwable)updateItem.getMessage());
        }
        String value = CmsStringUtil.escapeJavaScript((String)updateItem.getMessage());
        switch (format) {
            case fmtHeadline: {
                buf = new StringBuffer();
                buf.append("aH('");
                buf.append(value);
                buf.append("'); ");
                break;
            }
            case fmtWarning: {
                buf = new StringBuffer();
                buf.append("aW('");
                buf.append(value);
                buf.append("'); ");
                break;
            }
            case fmtError: {
                buf = new StringBuffer();
                buf.append("aE('");
                buf.append(value);
                buf.append("'); ");
                break;
            }
            case fmtNote: {
                buf = new StringBuffer();
                buf.append("aN('");
                buf.append(value);
                buf.append("'); ");
                break;
            }
            case fmtOk: {
                buf = new StringBuffer();
                buf.append("aO('");
                buf.append(value);
                buf.append("'); ");
                break;
            }
            case fmtNewline: {
                buf = new StringBuffer();
                buf.append("a('<br>');");
                break;
            }
            default: {
                buf = new StringBuffer();
                buf.append("a('");
                buf.append(value);
                buf.append("'); ");
            }
        }
        if (value.trim().endsWith("<br>")) {
            buf.append("aB(); ");
        }
        return buf.toString();
    }
}

