/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsUUID;

public class CmsLinkInfo {
    public static final CmsLinkInfo EMPTY = new CmsLinkInfo(CmsUUID.getNullUUID(), null, null, null, null, true);
    private String m_anchor;
    private transient int m_hashCode;
    private boolean m_internal;
    private String m_query;
    private CmsUUID m_structureId;
    private String m_target;
    private transient String m_toStringRepr;
    private CmsRelationType m_type;

    public CmsLinkInfo(CmsUUID structureId, String target, String query, String anchor, CmsRelationType type, boolean internal) {
        this.m_structureId = structureId;
        this.m_target = target;
        this.m_query = query;
        this.m_anchor = anchor;
        this.m_type = type;
        this.m_internal = internal;
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.m_hashCode = hashCodeBuilder.append((Object)this.m_structureId).append((Object)this.m_target).append((Object)this.m_query).append((Object)this.m_anchor).append(this.m_internal).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CmsLinkInfo other = (CmsLinkInfo)obj;
        if (this.m_anchor == null ? other.m_anchor != null : !this.m_anchor.equals(other.m_anchor)) {
            return false;
        }
        if (this.m_internal != other.m_internal) {
            return false;
        }
        if (this.m_query == null ? other.m_query != null : !this.m_query.equals(other.m_query)) {
            return false;
        }
        if (this.m_structureId == null ? other.m_structureId != null : !this.m_structureId.equals(other.m_structureId)) {
            return false;
        }
        return !(this.m_target == null ? other.m_target != null : !this.m_target.equals(other.m_target));
    }

    public String getAnchor() {
        return this.m_anchor;
    }

    public String getQuery() {
        return this.m_query;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public String getTarget() {
        return this.m_target;
    }

    public CmsRelationType getType() {
        return this.m_type;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean isInternal() {
        return this.m_internal;
    }

    public CmsLink toLink() {
        if (this == EMPTY) {
            return null;
        }
        return new CmsLink(this);
    }

    public String toString() {
        if (this.m_toStringRepr == null) {
            this.m_toStringRepr = ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
        return this.m_toStringRepr;
    }
}

