/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;

public class CmsPdfUserAgent
extends NaiveUserAgent {
    public static final Pattern SCALE_PARAMS_PATTERN = Pattern.compile("__scale=(.*?)(?:&|$)");
    private static final int IMAGE_CACHE_CAPACITY = 64;
    private static final Log LOG = CmsLog.getLog(CmsPdfUserAgent.class);
    private CmsObject m_cms;
    private CmsObject m_rootCms;
    private SharedContext m_sharedContext;

    public CmsPdfUserAgent(CmsObject cms) throws CmsException {
        super(64);
        this.m_cms = cms;
        this.m_rootCms = OpenCms.initCmsObject(cms);
        this.m_rootCms.getRequestContext().setSiteRoot("");
    }

    public byte[] getBinaryResource(String uri) {
        return this.readFile(uri);
    }

    public CSSResource getCSSResource(String uri) {
        return new CSSResource((InputStream)this.getStream(this.readFile(uri)));
    }

    public ImageResource getImageResource(String uri) {
        byte[] imageData;
        ImageResource resource = null;
        resource = (ImageResource)this._imageCache.get(uri);
        if (resource == null && (imageData = this.readImage(uri)) != null) {
            try {
                Image image = Image.getInstance((byte[])imageData);
                this.scaleToOutputResolution(image);
                resource = new ImageResource(uri, (FSImage)new ITextFSImage(image));
                this._imageCache.put(uri, resource);
            }
            catch (Exception e) {
                LOG.error((Object)("Problem with getting image resource " + uri), (Throwable)e);
            }
        }
        resource = resource != null ? new ImageResource(resource.getImageUri(), (FSImage)((ITextFSImage)resource.getImage()).clone()) : new ImageResource(uri, null);
        return resource;
    }

    public SharedContext getSharedContext() {
        return this.m_sharedContext;
    }

    public String resolveURI(String uri) {
        return uri;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this.m_sharedContext = sharedContext;
    }

    ByteArrayInputStream getStream(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    private byte[] readFile(String uriWithParams) {
        try {
            String pathAndQuery = OpenCms.getLinkManager().getRootPath(this.m_cms, uriWithParams);
            URI uri = new URI(pathAndQuery);
            String path = uri.getPath();
            CmsFile file = this.m_rootCms.readFile(path);
            return file.getContents();
        }
        catch (Exception e) {
            LOG.error((Object)("Problem with reading CSS " + uriWithParams + ": " + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    private byte[] readImage(String uriWithParams) {
        try {
            Matcher matcher;
            String pathAndQuery = OpenCms.getLinkManager().getRootPath(this.m_cms, uriWithParams);
            URI uri = new URI(pathAndQuery);
            String path = uri.getPath();
            String query = uri.getQuery();
            String scaleParams = null;
            if (query != null && (matcher = SCALE_PARAMS_PATTERN.matcher(query)).find()) {
                scaleParams = matcher.group(1);
            }
            CmsFile imageFile = this.m_rootCms.readFile(path);
            byte[] result = imageFile.getContents();
            if (scaleParams != null) {
                CmsImageScaler scaler = new CmsImageScaler(scaleParams);
                result = scaler.scaleImage(imageFile);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("Problem with reading image " + uriWithParams + ": " + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.m_sharedContext.getDotsPerPixel();
        if (factor != 1.0f) {
            image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
        }
    }
}

