/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;

public class CmsPdfThumbnailGenerator {
    private static final int FAKE_PIXEL_MULTIPLIER = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateThumbnail(InputStream pdfInputStream, int boxWidth, int boxHeight, String imageFormat, int pageIndex) throws Exception {
        ObjectStore.temp_dir = CmsFileUtil.normalizePath(OpenCms.getSystemInfo().getWebInfRfsPath() + "imagecache/pdfthumbnails" + File.separatorChar);
        PdfDecoder decoder = new PdfDecoder(true);
        try {
            byte[] imageData;
            decoder.openPdfFileFromInputStream(pdfInputStream, false);
            int numPages = decoder.getPageCount();
            if (pageIndex >= numPages) {
                pageIndex = numPages - 1;
            } else if (pageIndex < 0) {
                pageIndex = 0;
            }
            PdfPageData pageData = decoder.getPdfPageData();
            double aspectRatio = (double)pageData.getCropBoxWidth(1 + pageIndex) * 1.0 / (double)pageData.getCropBoxHeight(1 + pageIndex);
            int rotation = pageData.getRotation(1 + pageIndex);
            if (rotation == 90 || rotation == 270) {
                aspectRatio = 1.0 / aspectRatio;
            }
            if (boxWidth < 0 && boxHeight < 0) {
                throw new IllegalArgumentException("At least one of width / height must be positive!");
            }
            if (boxWidth < 0 && boxHeight > 0) {
                boxWidth = (int)Math.round(aspectRatio * (double)boxHeight);
            } else if (boxWidth > 0 && boxHeight < 0) {
                boxHeight = (int)Math.round((double)boxWidth / aspectRatio);
            }
            int fakePixelWidth = (int)(10000.0 * aspectRatio);
            int fakePixelHeight = 10000;
            int[] unpaddedThumbnailDimensions = CmsImageScaler.calculateDimension(fakePixelWidth, fakePixelHeight, boxWidth, boxHeight);
            decoder.decodePage(1 + pageIndex);
            BufferedImage pageImage = decoder.getPageAsImage(1 + pageIndex);
            BufferedImage paddedImage = new BufferedImage(boxWidth, boxHeight, 5);
            Graphics2D g = paddedImage.createGraphics();
            int uw = unpaddedThumbnailDimensions[0];
            int uh = unpaddedThumbnailDimensions[1];
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance((double)uw * 1.0 / (double)pageImage.getWidth(), (double)uh * 1.0 / (double)pageImage.getHeight()), 2);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, paddedImage.getWidth(), paddedImage.getHeight());
            g.drawImage(pageImage, op, (boxWidth - uw) / 2, (boxHeight - uh) / 2);
            BufferedImage pageThumbnail = paddedImage;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIOUtil.writeImage((BufferedImage)pageThumbnail, (String)imageFormat, (OutputStream)out);
            byte[] byArray = imageData = out.toByteArray();
            return byArray;
        }
        finally {
            if (decoder.isOpen()) {
                decoder.closePdfFile();
            }
            pdfInputStream.close();
        }
    }

    static {
        FontMappings.setFontReplacements();
    }
}

