/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.pdftools.CmsPdfUserAgent;
import org.opencms.pdftools.CmsXRLogAdapter;
import org.opencms.pdftools.dtds.FailingEntityResolver;
import org.opencms.pdftools.dtds.XhtmlEntityResolver;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRLogger;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CmsPdfConverter {
    private EntityResolver m_entityResolver = new XhtmlEntityResolver(new FailingEntityResolver());

    public byte[] convertXhtmlToPdf(CmsObject cms, byte[] xhtmlData, String uri) throws Exception {
        Document doc = this.readDocument(xhtmlData);
        ITextRenderer renderer = new ITextRenderer();
        CmsPdfUserAgent userAgent = new CmsPdfUserAgent(cms);
        userAgent.setSharedContext(renderer.getSharedContext());
        renderer.getSharedContext().setUserAgentCallback((UserAgentCallback)userAgent);
        renderer.setDocument(doc, uri);
        renderer.layout();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        renderer.createPDF((OutputStream)out);
        return out.toByteArray();
    }

    private Document readDocument(byte[] xhtmlData) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docbuilder = docBuilderFactory.newDocumentBuilder();
        docbuilder.setEntityResolver(this.m_entityResolver);
        Document doc = docbuilder.parse(new ByteArrayInputStream(xhtmlData));
        return doc;
    }

    static {
        System.getProperties().setProperty("xr.util-logging.loggingEnabled", "true");
        XRLog.setLoggingEnabled((boolean)true);
        XRLog.setLoggerImpl((XRLogger)new CmsXRLogAdapter());
    }
}

