/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.mx.I_CmsDiagnosticsMXBean;

public class CmsDiagnosticsMXBean
implements I_CmsDiagnosticsMXBean {
    public static final CmsDiagnosticsMXBean INSTANCE = new CmsDiagnosticsMXBean();
    private static CmsObject adminCms;
    private static final Log LOG;

    public static void register(CmsObject cms) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        adminCms = OpenCms.initCmsObject(cms);
        ObjectName mxbeanName = new ObjectName("org.opencms.mx:type=CmsDiagnosticsMXBean");
        mbs.registerMBean(INSTANCE, mxbeanName);
    }

    @Override
    public String listActiveRequests() {
        ArrayList<OpenCmsServlet.RequestInfo> infos = new ArrayList<OpenCmsServlet.RequestInfo>(OpenCmsServlet.activeRequests.values());
        long now = System.currentTimeMillis();
        infos.sort((a, b) -> Long.compare(a.getStartTime(), b.getStartTime()));
        StringBuilder result = new StringBuilder();
        for (OpenCmsServlet.RequestInfo info : infos) {
            String line = "(#" + info.getThreadId() + ") " + info.getUri() + " " + (now - info.getStartTime());
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    static {
        LOG = CmsLog.getLog(CmsDiagnosticsMXBean.class);
    }
}

