/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.monitor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsLog;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.I_CmsMemoryMonitorable;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;

public class CmsGroupListCache
implements I_CmsMemoryMonitorable {
    public static volatile int GROUP_LISTS_PER_USER = 32;
    private static final Log LOG = CmsLog.getLog(CmsGroupListCache.class);
    private LoadingCache<CmsUUID, Entry> m_internalCache;
    private Interner<String> m_interner = Interners.newBuilder().concurrencyLevel(8).build();

    public CmsGroupListCache(int size) {
        this.m_internalCache = CacheBuilder.newBuilder().concurrencyLevel(8).maximumSize((long)size).build((CacheLoader)new CacheLoader<CmsUUID, Entry>(){

            public Entry load(CmsUUID key) throws Exception {
                return new Entry();
            }
        });
    }

    static <T, V> Map<T, V> createLRUCacheMap(int capacity) {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize((long)capacity);
        return builder.build().asMap();
    }

    public void clear() {
        if (LOG.isInfoEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"CmsGroupListCache.clear() called", (Throwable)new Exception("(dummy exception)"));
            } else {
                LOG.info((Object)"CmsGroupListCache.clear() called");
            }
        }
        this.m_internalCache.invalidateAll();
    }

    public void clearUser(CmsUUID idKey) {
        if (idKey != null) {
            this.m_internalCache.invalidate((Object)idKey);
        }
    }

    public List<CmsRole> getBareRoles(CmsUUID userId) {
        Entry entry = (Entry)this.m_internalCache.getIfPresent((Object)userId);
        if (entry == null) {
            return null;
        }
        return entry.getBareRoles();
    }

    public List<CmsGroup> getGroups(CmsUUID userId, String subKey) {
        Entry userEntry = (Entry)this.m_internalCache.getIfPresent((Object)userId);
        if (userEntry == null) {
            return null;
        }
        List<CmsGroup> result = userEntry.getGroupCache().get(subKey);
        if (result != null) {
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    public Boolean getHasRole(CmsUUID userId, String roleKey) {
        Entry userEntry = (Entry)this.m_internalCache.getIfPresent((Object)userId);
        if (userEntry == null) {
            return null;
        }
        return userEntry.getHasRoleCache().get(roleKey);
    }

    @Override
    public int getMemorySize() {
        return (int)CmsMemoryMonitor.getValueSize(this.m_internalCache.asMap());
    }

    public void setBareRoles(CmsUser user, List<CmsRole> bareRoles) {
        if (!user.isWebuser()) {
            CmsUUID userId = user.getId();
            ((Entry)this.m_internalCache.getUnchecked((Object)userId)).setBareRoles(bareRoles);
        }
    }

    public void setGroups(CmsUser user, String subKey, List<CmsGroup> groups) {
        if (!user.isWebuser()) {
            CmsUUID userId = user.getId();
            Map<String, List<CmsGroup>> groupCache = ((Entry)this.m_internalCache.getUnchecked((Object)userId)).getGroupCache();
            groupCache.put(subKey, new ArrayList<CmsGroup>(groups));
        }
    }

    public void setHasRole(CmsUser user, String roleKey, Boolean value) {
        if (!user.isWebuser()) {
            roleKey = (String)this.m_interner.intern((Object)roleKey);
            CmsUUID userId = user.getId();
            ((Entry)this.m_internalCache.getUnchecked((Object)userId)).getHasRoleCache().put(roleKey, value);
        }
    }

    public int size() {
        return (int)this.m_internalCache.size();
    }

    class Entry
    implements I_CmsMemoryMonitorable {
        private volatile List<CmsRole> m_bareRoles;
        private Map<String, List<CmsGroup>> m_groupCache = CmsGroupListCache.createLRUCacheMap(GROUP_LISTS_PER_USER);
        private Map<String, Boolean> m_hasRoleCache = new ConcurrentHashMap<String, Boolean>();

        Entry() {
        }

        public List<CmsRole> getBareRoles() {
            return this.m_bareRoles;
        }

        public Map<String, List<CmsGroup>> getGroupCache() {
            return this.m_groupCache;
        }

        public Map<String, Boolean> getHasRoleCache() {
            return this.m_hasRoleCache;
        }

        @Override
        public int getMemorySize() {
            return (int)(CmsMemoryMonitor.getValueSize(this.m_groupCache) + CmsMemoryMonitor.getValueSize(this.m_hasRoleCache) + CmsMemoryMonitor.getValueSize(this.m_bareRoles));
        }

        public void setBareRoles(List<CmsRole> bareRoles) {
            this.m_bareRoles = bareRoles;
        }
    }
}

