/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;

public class CmsModuleLog {
    private static final Log LOG = CmsLog.getLog(CmsModuleLog.class);
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd/HH:mm:ss";

    public File getLogFile(String moduleName) {
        return new File(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("packages/_modulelogs/" + moduleName + ".log"));
    }

    public synchronized void log(String moduleName, Action action, boolean ok) {
        if (moduleName == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_STRING);
        String now = format.format(new Date());
        String message = now + " " + action.getPrintName() + " " + (ok ? "0" : "1");
        this.log(moduleName, message);
    }

    public synchronized byte[] readLog(String moduleName) throws IOException {
        File logFile = this.getLogFile(moduleName);
        if (logFile.exists()) {
            return CmsFileUtil.readFile(logFile);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void log(String moduleName, String message) {
        File logFile = this.getLogFile(moduleName);
        logFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try (PrintStream ps = null;){
            out = new FileOutputStream(logFile, true);
            ps = new PrintStream(out);
            ps.println(message);
        }
    }

    public static enum Action {
        importModule("import"),
        exportModule("export"),
        deleteModule("delete");

        private String m_printName;

        private Action(String printName) {
            this.m_printName = printName;
        }

        public String getPrintName() {
            return this.m_printName;
        }
    }
}

