/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.Serializable;
import org.opencms.module.CmsModuleVersion;

public class CmsModuleDependency
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = -464911120361037953L;
    private int m_hashCode;
    private String m_name;
    private CmsModuleVersion m_version;

    public CmsModuleDependency() {
        this.m_name = "";
        this.m_version = new CmsModuleVersion("0");
        this.m_hashCode = this.m_name.concat(this.m_version.toString()).hashCode();
    }

    public CmsModuleDependency(String moduleName, CmsModuleVersion minVersion) {
        this.m_name = moduleName;
        this.m_version = minVersion;
        this.m_hashCode = this.m_name.concat(this.m_version.toString()).hashCode();
    }

    public Object clone() {
        return new CmsModuleDependency(this.m_name, new CmsModuleVersion(this.m_version.getVersion()));
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsModuleDependency) {
            CmsModuleDependency other = (CmsModuleDependency)obj;
            if (!this.m_name.equals(other.m_name)) {
                return 0;
            }
            return this.m_version.compareTo(other.m_version);
        }
        return 0;
    }

    public boolean dependesOn(CmsModuleDependency other) {
        if (!this.m_name.equals(other.m_name)) {
            return false;
        }
        return this.m_version.compareTo(other.m_version) <= 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsModuleDependency) {
            CmsModuleDependency other = (CmsModuleDependency)obj;
            return this.m_name.equals(other.m_name) && this.m_version.equals(other.m_version);
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public CmsModuleVersion getVersion() {
        return this.m_version;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public void setVersion(CmsModuleVersion value) {
        this.m_version = value;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ", name: " + this.m_name + ", version: " + String.valueOf(this.m_version) + "]";
    }
}

