/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.CloseableThreadContext;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class OpenCmsUrlServletFilter
implements Filter {
    static final Log LOG = CmsLog.getLog(OpenCmsUrlServletFilter.class);
    private static final String INIT_PARAM_ADDITIONAL_EXCLUDEPREFIXES = "additionalExcludePrefixes";
    private String m_additionalExcludePrefixes;
    private String m_contextPath;
    private boolean m_isInitialized;
    private String m_regex;
    private String m_servletPath;

    static String createRegex(String contextPath, String[] defaultExcludePrefixes, String additionalExcludePrefixes) {
        StringBuffer regex = new StringBuffer();
        regex.append(contextPath);
        regex.append('(');
        regex.append(defaultExcludePrefixes[0]);
        for (int i = 1; i < defaultExcludePrefixes.length; ++i) {
            regex.append('|').append(defaultExcludePrefixes[i]);
        }
        if (null != additionalExcludePrefixes && !additionalExcludePrefixes.isEmpty()) {
            regex.append('|').append(additionalExcludePrefixes);
        }
        regex.append(')');
        regex.append(".*");
        return regex.toString();
    }

    public void destroy() {
        this.m_additionalExcludePrefixes = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HashMap<String, String> loggingInfo = new HashMap<String, String>();
        loggingInfo.put("request_id", RandomStringUtils.randomAlphanumeric((int)6));
        if (request instanceof HttpServletRequest) {
            Object url = ((HttpServletRequest)request).getRequestURL().toString();
            String query = ((HttpServletRequest)request).getQueryString();
            if (!CmsStringUtil.isEmpty(query)) {
                url = (String)url + "?" + query;
            }
            loggingInfo.put("request_url", (String)url);
        }
        try (CloseableThreadContext.Instance threadContext = CloseableThreadContext.putAll(loggingInfo);){
            HttpServletRequest req;
            String uri;
            LOG.info((Object)("Updating log context: " + String.valueOf(loggingInfo)));
            if ((this.m_isInitialized || this.tryToInitialize()) && request instanceof HttpServletRequest && !(uri = (req = (HttpServletRequest)request).getRequestURI()).matches(this.m_regex)) {
                String adjustedUri = uri.replaceFirst(this.m_contextPath + "/", this.m_servletPath);
                req.getRequestDispatcher(adjustedUri).forward(request, response);
                return;
            }
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.m_additionalExcludePrefixes = filterConfig.getInitParameter(INIT_PARAM_ADDITIONAL_EXCLUDEPREFIXES);
    }

    boolean tryToInitialize() {
        if (this.m_isInitialized) {
            return true;
        }
        if (OpenCms.getRunLevel() == 4) {
            this.m_contextPath = OpenCms.getSystemInfo().getContextPath();
            this.m_servletPath = OpenCms.getSystemInfo().getServletPath() + "/";
            String[] defaultExcludePrefixes = new String[]{"/" + OpenCms.getStaticExportManager().getExportPathForConfiguration(), "/workplace", "/VAADIN/", this.m_servletPath, "/resources/", "/webdav", "/webdav2", "/cmisatom", "/handle404", "/services"};
            StringBuffer regex = new StringBuffer();
            regex.append(this.m_contextPath);
            regex.append('(');
            regex.append(defaultExcludePrefixes[0]);
            for (int i = 1; i < defaultExcludePrefixes.length; ++i) {
                regex.append('|').append(defaultExcludePrefixes[i]);
            }
            if (null != this.m_additionalExcludePrefixes && !this.m_additionalExcludePrefixes.isEmpty()) {
                regex.append('|').append(this.m_additionalExcludePrefixes);
            }
            regex.append(')');
            regex.append(".*");
            this.m_regex = regex.toString();
            this.m_isInitialized = true;
            return true;
        }
        return false;
    }
}

