/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import com.vaadin.server.BootstrapFragmentResponse;
import com.vaadin.server.BootstrapListener;
import com.vaadin.server.BootstrapPageResponse;
import com.vaadin.server.CustomizedSystemMessages;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.RequestHandler;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.SystemMessages;
import com.vaadin.server.SystemMessagesInfo;
import com.vaadin.server.SystemMessagesProvider;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.opencms.ade.publish.ClientMessages;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.file.CmsObject;
import org.opencms.gwt.CmsCoreService;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsVaadinServletService;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.Messages;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.util.CmsRequestUtil;
import org.opencms.workplace.CmsWorkplace;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class CmsUIServlet
extends VaadinServlet
implements SystemMessagesProvider,
SessionInitListener {
    static final BootstrapListener BOOTSTRAP_LISTENER = new BootstrapListener(){
        private static final long serialVersionUID = -6249561809984101044L;

        public void modifyBootstrapFragment(BootstrapFragmentResponse response) {
        }

        public void modifyBootstrapPage(BootstrapPageResponse response) {
            CmsCoreService svc = new CmsCoreService();
            HttpServletRequest request = (HttpServletRequest)VaadinService.getCurrentRequest();
            svc.setRequest(request);
            CmsObject cms = ((CmsUIServlet)VaadinServlet.getCurrent()).getCmsObject();
            svc.setCms(cms);
            Document doc = response.getDocument();
            Elements appLoadingElements = doc.getElementsByClass("v-app-loading");
            if (appLoadingElements.size() > 0) {
                for (Node node : ((Element)appLoadingElements.get(0)).childNodes()) {
                    node.remove();
                }
                ((Element)appLoadingElements.get(0)).append("<div class='o-loading-indicator opencms-font'><div class=\"oc-spin-center\">\n<span class=\"oc-spinner-bg\"></span>\n<span class=\"oc-spinner oc-spin-outer\"></span><br>\n<span class=\"oc-spinner-circle oc-spin-inner\"></span><br>\n<span class=\"oc-spinner-dots oc-spin-dots\"></span>\n</div></div>");
            }
            if (CmsUIServlet.shouldShowLogin()) {
                try {
                    String html = CmsLoginUI.generateLoginHtmlFragment(cms, response.getRequest());
                    Element el = new Element(Tag.valueOf((String)"div"), "").html(html);
                    doc.body().appendChild((Node)el);
                }
                catch (IOException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            Locale currentLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            try {
                doc.head().append(CmsGwtActionElement.exportCommon(cms, svc.prefetch()));
                doc.head().append(ClientMessages.get().export(currentLocale, true));
                doc.head().append(org.opencms.ade.upload.ClientMessages.get().export(currentLocale, true));
                doc.head().append(org.opencms.ade.galleries.ClientMessages.get().export(currentLocale, true));
                for (String cssURI : OpenCms.getWorkplaceAppManager().getWorkplaceCssUris()) {
                    doc.head().append("<link rel=\"stylesheet\" href=\"" + CmsWorkplace.getResourceUri(cssURI) + "\">");
                }
                doc.head().append("<script>window.addEventListener('pageshow', function(e) { if (e.persisted) { window.location.reload(); } });</script>");
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            response.setHeader("Cache-Control", "no-store");
        }
    };
    static final Log LOG = CmsLog.getLog(CmsUIServlet.class);
    static final UIProvider LOGIN_UI_PROVIDER = new UIProvider(){
        private static final long serialVersionUID = 9154828335594149982L;

        public Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
            if (CmsUIServlet.shouldShowLogin() || CmsUIServlet.isLoginUIRequest(event.getRequest())) {
                return CmsLoginUI.class;
            }
            return null;
        }
    };
    static final RequestHandler REQUEST_AUTHORIZATION_HANDLER = new RequestHandler(){
        private static final long serialVersionUID = 1L;

        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            if (CmsUIServlet.shouldShowLogin() && !CmsUIServlet.isLoginUIRequest(request)) {
                Object link = OpenCms.getLinkManager().substituteLinkForUnknownTarget(((CmsUIServlet)VaadinServlet.getCurrent()).getCmsObject(), "/system/login/index.html");
                String requestedUri = ((HttpServletRequest)request).getRequestURI();
                if (!requestedUri.endsWith(OpenCms.getSystemInfo().getWorkplaceContext())) {
                    try {
                        link = (String)link + "?requestedResource=" + URLEncoder.encode(requestedUri, "UTF-8") + "&encryptedRequestedResource=" + OpenCms.getDefaultTextEncryption().encrypt(requestedUri);
                    }
                    catch (CmsEncryptionException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                OpenCms.getAuthorizationHandler().requestAuthorization((HttpServletRequest)request, (HttpServletResponse)response, (String)link);
                return true;
            }
            return false;
        }
    };
    private static final long serialVersionUID = 8119684308154724518L;
    private static final String HEARTBEAT_PREFIX = "/HEARTBEAT/";
    private ThreadLocal<CmsObject> m_perThreadCmsObject = new ThreadLocal();
    private Map<Locale, SystemMessages> m_systemMessages = new ConcurrentHashMap<Locale, SystemMessages>();
    private ThreadLocal<Boolean> m_perThreadBroadcastPoll = new ThreadLocal();

    static boolean isLoginUIRequest(VaadinRequest request) {
        String referrer = request.getHeader("referer");
        return referrer != null && referrer.contains("/system/login");
    }

    static boolean shouldShowLogin() {
        return ((CmsUIServlet)CmsUIServlet.getCurrent()).getCmsObject().getRequestContext().getCurrentUser().isGuestUser();
    }

    public CmsObject getCmsObject() {
        return this.m_perThreadCmsObject.get();
    }

    public SystemMessages getSystemMessages(SystemMessagesInfo systemMessagesInfo) {
        Locale locale = systemMessagesInfo.getLocale();
        if (!this.m_systemMessages.containsKey(locale)) {
            this.m_systemMessages.put(locale, this.createSystemMessages(locale));
        }
        return this.m_systemMessages.get(locale);
    }

    public void sessionInit(SessionInitEvent event) {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        event.getSession().setLocale(wpLocale);
        event.getSession().addRequestHandler(REQUEST_AUTHORIZATION_HANDLER);
        event.getSession().addUIProvider(LOGIN_UI_PROVIDER);
        event.getSession().addBootstrapListener(BOOTSTRAP_LISTENER);
    }

    public void setBroadcastPoll() {
        this.m_perThreadBroadcastPoll.set(Boolean.TRUE);
    }

    public synchronized void setCms(CmsObject cms) {
        this.m_perThreadCmsObject.set(cms);
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        CmsVaadinServletService service = new CmsVaadinServletService(this, deploymentConfiguration);
        service.init();
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CmsRequestUtil.disableCrossSiteFrameEmbedding(response);
        if (request.getRequestURI().contains("/VAADIN")) {
            super.service(request, response);
            return;
        }
        int runlevel = OpenCmsCore.getInstance().getRunLevel();
        response.setHeader("Server", OpenCmsCore.getInstance().getSystemInfo().getVersion());
        if (runlevel != 4) {
            if (runlevel == 3) {
                this.init(this.getServletConfig());
            } else {
                response.sendError(403);
                return;
            }
        }
        if (OpenCms.getSiteManager().getSites().size() > 1 && !OpenCms.getSiteManager().isWorkplaceRequest(request)) {
            response.sendError(404);
            return;
        }
        try {
            OpenCmsCore.getInstance().initCmsContextForUI(request, response, this);
            super.service(request, response);
            OpenCms.getSessionManager().updateSessionInfo(this.getCmsObject(), request, this.isHeartbeatRequest(request));
        }
        catch (CmsRoleViolationException rv) {
            LOG.debug((Object)rv.getLocalizedMessage(), (Throwable)rv);
            int status = 500;
            response.setStatus(status);
            try {
                response.sendError(status, rv.toString());
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (IOException io) {
            LOG.warn((Object)io.getLocalizedMessage(), (Throwable)io);
            int status = 500;
            response.setStatus(status);
            try {
                response.sendError(status, io.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
            int status = 500;
            response.setStatus(status);
            try {
                response.sendError(status, t.toString());
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            this.clearThreadLocal();
        }
    }

    protected void servletInitialized() throws ServletException {
        super.servletInitialized();
        this.getService().setSystemMessagesProvider((SystemMessagesProvider)this);
        this.getService().addSessionInitListener((SessionInitListener)this);
    }

    private void clearThreadLocal() {
        this.m_perThreadCmsObject.set(null);
        this.m_perThreadBroadcastPoll.remove();
    }

    private SystemMessages createSystemMessages(Locale locale) {
        CmsMessages messages = Messages.get().getBundle(locale);
        CustomizedSystemMessages systemMessages = new CustomizedSystemMessages();
        systemMessages.setCommunicationErrorCaption(messages.key("GUI_SYSTEM_COMMUNICATION_ERROR_CAPTION_0"));
        systemMessages.setCommunicationErrorMessage(messages.key("GUI_SYSTEM_COMMUNICATION_ERROR_MESSAGE_0"));
        systemMessages.setCommunicationErrorNotificationEnabled(true);
        systemMessages.setAuthenticationErrorCaption(messages.key("GUI_SYSTEM_AUTHENTICATION_ERROR_CAPTION_0"));
        systemMessages.setAuthenticationErrorMessage(messages.key("GUI_SYSTEM_AUTHENTICATION_ERROR_MESSAGE_0"));
        systemMessages.setAuthenticationErrorNotificationEnabled(true);
        systemMessages.setSessionExpiredCaption(messages.key("GUI_SYSTEM_SESSION_EXPIRED_ERROR_CAPTION_0"));
        systemMessages.setSessionExpiredMessage(messages.key("GUI_SYSTEM_SESSION_EXPIRED_ERROR_MESSAGE_0"));
        systemMessages.setSessionExpiredNotificationEnabled(true);
        systemMessages.setInternalErrorCaption(messages.key("GUI_SYSTEM_INTERNAL_ERROR_CAPTION_0"));
        systemMessages.setInternalErrorMessage(messages.key("GUI_SYSTEM_INTERNAL_ERROR_MESSAGE_0"));
        systemMessages.setInternalErrorNotificationEnabled(true);
        return systemMessages;
    }

    private boolean isHeartbeatRequest(HttpServletRequest request) {
        if (this.m_perThreadBroadcastPoll.get() != null && this.m_perThreadBroadcastPoll.get().booleanValue()) {
            return true;
        }
        String pathInfo = request.getPathInfo();
        return pathInfo != null && pathInfo.startsWith(HEARTBEAT_PREFIX);
    }

    static {
        SLF4JBridgeHandler.install();
    }
}

