/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsSecurityManager;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.publish.CmsPublishManager;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsUUID;

public final class CmsThreadStore
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsThreadStore.class);
    private static final int ONE_MINUTE_IN_MILLIS = 60000;
    private static final int UPDATE_MINUTES_INTERVAL = 5;
    private boolean m_alive;
    private CmsSecurityManager m_securityManager;
    private Map<CmsUUID, A_CmsReportThread> m_threads;

    protected CmsThreadStore(CmsSecurityManager securityManager) {
        super(new ThreadGroup("OpenCms Thread Store"), "OpenCms: Grim Reaper");
        this.setDaemon(true);
        this.m_threads = new Hashtable<CmsUUID, A_CmsReportThread>();
        this.m_alive = true;
        this.m_securityManager = securityManager;
        this.start();
    }

    public void addThread(A_CmsReportThread thread) {
        this.m_threads.put(thread.getUUID(), thread);
        if (LOG.isDebugEnabled()) {
            this.dumpThreads();
        }
    }

    public A_CmsReportThread retrieveThread(CmsUUID key) {
        if (LOG.isDebugEnabled()) {
            this.dumpThreads();
        }
        return this.m_threads.get(key);
    }

    @Override
    public void run() {
        boolean checkPublishQueue = true;
        int minutesForCheck = 0;
        while (this.m_alive) {
            try {
                CmsThreadStore.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.handleDoomedThreads();
            if (++minutesForCheck < 5) continue;
            minutesForCheck = 0;
            checkPublishQueue = !checkPublishQueue;
            this.validateSessions();
            this.persistData();
            if (!checkPublishQueue) continue;
            this.checkPublishQueue();
        }
    }

    protected void checkPublishQueue() {
        try {
            CmsPublishManager publishManager = OpenCms.getPublishManager();
            if (publishManager == null) {
                return;
            }
            CmsPublishJobRunning publishJob = publishManager.getCurrentPublishJob();
            if (publishJob == null) {
                publishManager.checkCurrentPublishJobThread();
                return;
            }
            CmsUUID uid = publishJob.getThreadUUID();
            if (uid == null || uid.isNullUUID()) {
                return;
            }
            A_CmsReportThread thread = this.m_threads.get(uid);
            if (thread == null) {
                return;
            }
            if (System.currentTimeMillis() - thread.getLastEntryTime() > 300000L) {
                this.m_threads.remove(thread);
                publishManager.abandonThread();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_PUBLISH_THREAD_ERROR_0"), t);
        }
    }

    protected void handleDoomedThreads() {
        try {
            Iterator<CmsUUID> i = this.m_threads.keySet().iterator();
            HashSet<CmsUUID> doomed = new HashSet<CmsUUID>();
            while (i.hasNext()) {
                CmsUUID key = i.next();
                A_CmsReportThread thread = this.m_threads.get(key);
                if (!thread.isDoomed()) continue;
                doomed.add(key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_THREADSTORE_DOOMED_2", thread.getName(), thread.getUUID()));
            }
            i = doomed.iterator();
            while (i.hasNext()) {
                this.m_threads.remove(i.next());
            }
            if (LOG.isDebugEnabled()) {
                this.dumpThreads();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_THREADS_ERROR_0"), t);
        }
    }

    protected void persistData() {
        block2: {
            try {
                this.m_securityManager.writeLocks();
                this.m_securityManager.updateLog();
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)org.opencms.lock.Messages.get().getBundle().key("ERR_WRITE_LOCKS_0"), t);
            }
        }
    }

    protected synchronized void shutDown() {
        this.m_alive = false;
        this.interrupt();
    }

    protected void validateSessions() {
        try {
            CmsSessionManager sessionInfoManager = OpenCms.getSessionManager();
            if (sessionInfoManager != null) {
                sessionInfoManager.validateSessionInfos();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_SESSIONS_ERROR_0"), t);
        }
    }

    private void dumpThreads() {
        if (LOG.isDebugEnabled()) {
            StringBuffer b = new StringBuffer(512);
            for (CmsUUID key : this.m_threads.keySet()) {
                A_CmsReportThread thread = this.m_threads.get(key);
                b.append(thread.getName());
                b.append(" - ");
                b.append(thread.getUUID());
                b.append('\n');
            }
            LOG.debug((Object)Messages.get().getBundle().key("LOG_THREADSTORE_POOL_CONTENT_2", this.m_threads.size(), b.toString()));
        }
    }
}

