/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.util.CmsStringUtil;

public class CmsStaticResourceHandler
implements I_CmsRequestHandler {
    public static final String HANDLER_NAME = "Static";
    public static final String STATIC_RESOURCE_PREFIX = "/handleStatic";
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_CACHE_TIME = 3600;
    private static final String[] HANDLER_NAMES = new String[]{"Static"};
    private static final Log LOG = CmsLog.getLog(CmsStaticResourceHandler.class);
    private static String m_removePrefixRegex;
    private static String m_staticResourceRegex;
    private static final String OPENCMS_PATH_PREFIX = "OPENCMS/";

    public static String getStaticResourceContext(String opencmsContext, String opencmsVersion) {
        return opencmsContext + "/handleStatic/v" + opencmsVersion.hashCode() + "v";
    }

    public static URL getStaticResourceURL(String resourcePath) {
        URL resourceURL = null;
        if (CmsStaticResourceHandler.isStaticResourceUri(resourcePath)) {
            String path = CmsStaticResourceHandler.removeStaticResourcePrefix(resourcePath);
            path = CmsStringUtil.joinPaths(OPENCMS_PATH_PREFIX, path);
            resourceURL = OpenCms.getSystemInfo().getClass().getClassLoader().getResource(path);
        }
        return resourceURL;
    }

    public static boolean isStaticResourceUri(String path) {
        return path != null && path.matches(CmsStaticResourceHandler.getStaticResourceRegex());
    }

    public static boolean isStaticResourceUri(URI uri) {
        return uri != null && CmsStaticResourceHandler.isStaticResourceUri(uri.getPath());
    }

    public static String removeStaticResourcePrefix(String path) {
        return path.replaceFirst(CmsStaticResourceHandler.getRemovePrefixRegex(), "");
    }

    private static String getRemovePrefixRegex() {
        if (m_removePrefixRegex == null) {
            m_removePrefixRegex = "^(" + OpenCms.getStaticExportManager().getVfsPrefix() + ")?/handleStatic(/v-?\\d+v/)?";
        }
        return m_removePrefixRegex;
    }

    private static String getStaticResourceRegex() {
        if (m_staticResourceRegex == null) {
            m_staticResourceRegex = CmsStaticResourceHandler.getRemovePrefixRegex() + ".*";
        }
        return m_staticResourceRegex;
    }

    @Override
    public String[] getHandlerNames() {
        return HANDLER_NAMES;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, String name) throws IOException {
        OpenCmsCore.getInstance();
        String path = OpenCmsCore.getPathInfo(request);
        URL resourceURL = CmsStaticResourceHandler.getStaticResourceURL(path);
        if (resourceURL != null) {
            this.setResponseHeaders(request, response, path, resourceURL);
            this.writeStaticResourceResponse(request, response, resourceURL);
        } else {
            response.setStatus(404);
        }
    }

    protected boolean allowServePrecompressedResource(HttpServletRequest request, String url) {
        String accept = request.getHeader("Accept-Encoding");
        return accept != null && accept.contains("gzip") && (url.endsWith(".js") || url.endsWith(".css") || url.endsWith(".html"));
    }

    protected int getCacheTime(String filename) {
        if (filename.contains(".nocache.")) {
            return 0;
        }
        if (filename.contains(".cache.")) {
            return 31536000;
        }
        return 3600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, String filename, URL resourceURL) {
        Object cacheControl = "public, max-age=0, must-revalidate";
        int resourceCacheTime = this.getCacheTime(filename);
        if (resourceCacheTime > 0) {
            cacheControl = "max-age=" + String.valueOf(resourceCacheTime);
        }
        response.setHeader("Cache-Control", (String)cacheControl);
        response.setDateHeader("Expires", System.currentTimeMillis() + (long)(resourceCacheTime * 1000));
        long lastModifiedTime = 0L;
        URLConnection connection = null;
        try {
            connection = resourceURL.openConnection();
            lastModifiedTime = connection.getLastModified();
            lastModifiedTime -= lastModifiedTime % 1000L;
            response.setDateHeader("Last-Modified", lastModifiedTime);
            if (this.browserHasNewestVersion(request, lastModifiedTime)) {
                response.setStatus(304);
                return;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to find out last modified timestamp. Continuing without it.", (Throwable)e);
        }
        finally {
            try {
                InputStream is;
                if (connection != null && (is = connection.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                LOG.info((Object)"Error closing URLConnection input stream", (Throwable)e);
            }
        }
        String mimetype = OpenCms.getResourceManager().getMimeType(filename, "UTF-8");
        if (mimetype != null) {
            response.setContentType(mimetype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStaticResourceResponse(HttpServletRequest request, HttpServletResponse response, URL resourceUrl) throws IOException {
        URLConnection connection = null;
        String urlStr = resourceUrl.toExternalForm();
        try (InputStream is = null;){
            if (this.allowServePrecompressedResource(request, urlStr)) {
                try {
                    connection = new URL(urlStr + ".gz").openConnection();
                    is = connection.getInputStream();
                    response.setHeader("Content-Encoding", "gzip");
                }
                catch (Exception e) {
                    LOG.debug((Object)("Unexpected exception looking for gzipped version of resource " + urlStr), (Throwable)e);
                }
            }
            if (is == null) {
                connection = resourceUrl.openConnection();
                try {
                    is = connection.getInputStream();
                }
                catch (FileNotFoundException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    response.setStatus(404);
                    if (is != null) {
                        is.close();
                    }
                    return;
                }
            }
            try {
                int length = connection.getContentLength();
                if (length >= 0) {
                    response.setContentLength(length);
                }
            }
            catch (Throwable e) {
                LOG.debug((Object)e.getMessage(), e);
            }
            this.streamContent(response, is);
        }
    }

    private boolean browserHasNewestVersion(HttpServletRequest request, long resourceLastModifiedTimestamp) {
        if (resourceLastModifiedTimestamp < 1L) {
            return false;
        }
        try {
            long headerIfModifiedSince = request.getDateHeader("If-Modified-Since");
            if (headerIfModifiedSince >= resourceLastModifiedTimestamp) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamContent(HttpServletResponse response, InputStream is) throws IOException {
        try (ServletOutputStream os = response.getOutputStream();){
            int bytes;
            byte[] buffer = new byte[32768];
            while ((bytes = is.read(buffer)) >= 0) {
                os.write(buffer, 0, bytes);
            }
        }
    }
}

