/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CmsSingleThreadDumperThread
extends Thread {
    private String m_filename;
    private String m_summaryFilename;
    private long m_threadId;
    private ThreadMXBean m_threadMx = ManagementFactory.getThreadMXBean();

    public CmsSingleThreadDumperThread(String filename, String summaryFilename, long id) {
        super(CmsSingleThreadDumperThread.class.getName());
        this.m_threadId = id;
        this.m_filename = filename;
        this.m_summaryFilename = summaryFilename;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count = 1;
        SampleNode root = new SampleNode("ROOT");
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.m_filename));){
            while (!this.isInterrupted()) {
                ThreadInfo info = this.m_threadMx.getThreadInfo(this.m_threadId, Integer.MAX_VALUE);
                List path = Lists.reverse(Arrays.asList(info.getStackTrace()));
                SampleNode.incrementPath(root, path);
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.formatThreadInfo(info));
                byte[] dumpData = buffer.toString().getBytes("UTF-8");
                ZipEntry entry = new ZipEntry("dump_" + count + ".txt");
                zip.putNextEntry(entry);
                zip.write(dumpData);
                ++count;
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.saveSummaryXml(root);
        }
    }

    String formatThreadInfo(ThreadInfo info) {
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\" Id=" + info.getThreadId() + " " + String.valueOf((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (int i = 0; i < info.getStackTrace().length; ++i) {
            StackTraceElement ste = info.getStackTrace()[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + String.valueOf(info.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(info.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(info.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : info.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + String.valueOf(mi));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private void saveSummaryXml(SampleNode root) {
        root.sortTree();
        Document doc = DocumentHelper.createDocument();
        Element rootElem = doc.addElement("root");
        root.appendToXml(rootElem);
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        outformat.setEncoding("UTF-8");
        try {
            XMLWriter writer = new XMLWriter((OutputStream)buffer, outformat);
            writer.write(doc);
            writer.flush();
            try (FileOutputStream fos = new FileOutputStream(this.m_summaryFilename);){
                fos.write(buffer.toByteArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SampleNode {
        private Map<Object, SampleNode> m_children = new LinkedHashMap<Object, SampleNode>();
        private Object m_key;
        private long m_samples;

        public SampleNode(Object key) {
            this.m_key = key;
        }

        public static int compareBySamplesDescending(SampleNode a, SampleNode b) {
            return -Long.compare(a.getSamples(), b.getSamples());
        }

        public static void incrementPath(SampleNode root, List<?> path) {
            List<SampleNode> nodes = SampleNode.nodesForPath(root, path);
            for (SampleNode node : nodes) {
                node.increment();
            }
        }

        public static List<SampleNode> nodesForPath(SampleNode root, List<?> path) {
            ArrayList<SampleNode> result = new ArrayList<SampleNode>();
            result.add(root);
            SampleNode current = root;
            for (Object key : path) {
                current = current.getOrAddChild(key);
                result.add(current);
            }
            return result;
        }

        public void appendToXml(Element parent) {
            Element element = parent.addElement("location").addAttribute("key", String.valueOf(this.m_key)).addAttribute("samples", "" + this.m_samples);
            for (SampleNode child : this.m_children.values()) {
                child.appendToXml(element);
            }
        }

        public Object getKey() {
            return this.m_key;
        }

        public SampleNode getOrAddChild(Object key) {
            SampleNode child = this.m_children.get(key);
            if (child == null) {
                child = new SampleNode(key);
                this.m_children.put(key, child);
            }
            return child;
        }

        public long getSamples() {
            return this.m_samples;
        }

        public boolean hasChildren() {
            return this.m_children.size() > 0;
        }

        public void increment() {
            ++this.m_samples;
        }

        public void sortChildren() {
            ArrayList<SampleNode> children = new ArrayList<SampleNode>(this.m_children.values());
            children.sort(SampleNode::compareBySamplesDescending);
            this.m_children.clear();
            for (SampleNode node : children) {
                this.m_children.put(node.getKey(), node);
            }
        }

        public void sortTree() {
            this.sortChildren();
            for (SampleNode child : this.m_children.values()) {
                child.sortTree();
            }
        }
    }
}

