/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.Messages;

public class CmsMultiException
extends CmsException {
    private static final long serialVersionUID = 1197300254684159700L;
    protected List<CmsException> m_exceptions = new ArrayList<CmsException>();
    protected boolean m_individualMessage;

    public CmsMultiException() {
        this(Messages.get().container("ERR_MULTI_EXCEPTION_1", 0));
    }

    public CmsMultiException(CmsMessageContainer message) {
        super(message);
        this.setMessage(message);
    }

    public CmsMultiException(List<CmsException> exceptions) {
        this();
        this.setExceptions(exceptions);
    }

    public void addException(CmsException exception) {
        this.m_exceptions.add(exception);
        this.updateMessage();
    }

    public void addExceptions(List<CmsException> exceptions) {
        this.m_exceptions.addAll(exceptions);
        this.updateMessage();
    }

    @Override
    public CmsException createException(CmsMessageContainer container, Throwable cause) {
        if (cause instanceof CmsMultiException) {
            CmsMultiException multiException = (CmsMultiException)cause;
            return new CmsMultiException(multiException.getExceptions());
        }
        return super.createException(container, cause);
    }

    public List<CmsException> getExceptions() {
        return Collections.unmodifiableList(this.m_exceptions);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.m_exceptions.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer(128);
        Iterator<CmsException> it = this.m_exceptions.iterator();
        while (it.hasNext()) {
            CmsException ex = it.next();
            result.append(ex.getLocalizedMessage());
            if (!it.hasNext()) continue;
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        if (this.m_exceptions.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer(128);
        Iterator<CmsException> it = this.m_exceptions.iterator();
        while (it.hasNext()) {
            CmsException ex = it.next();
            result.append(ex.getLocalizedMessage(locale));
            if (!it.hasNext()) continue;
            result.append('\n');
        }
        return result.toString();
    }

    public String getMessage(Locale locale) {
        if (this.hasIndividualMessage()) {
            return this.m_message.key(locale);
        }
        return "";
    }

    public boolean hasExceptions() {
        return !this.m_exceptions.isEmpty();
    }

    public boolean hasIndividualMessage() {
        return this.m_individualMessage;
    }

    public void setMessage(CmsMessageContainer message) {
        if (message != null && message.getKey() != "ERR_MULTI_EXCEPTION_1") {
            this.m_individualMessage = true;
            this.m_message = message;
        } else {
            this.m_individualMessage = false;
            this.updateMessage();
        }
    }

    protected void setExceptions(List<CmsException> exceptions) {
        this.m_exceptions = new ArrayList<CmsException>(exceptions);
        this.updateMessage();
    }

    protected void updateMessage() {
        if (!this.hasIndividualMessage()) {
            this.m_message = Messages.get().container("ERR_MULTI_EXCEPTION_1", this.m_exceptions.size());
        }
    }
}

