/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

public class CmsHttpAuthenticationSettings {
    public static final String AUTHENTICATION_BASIC = "BASIC";
    public static final String AUTHENTICATION_FORM = "FORM";
    public static final String DEFAULT_AUTHENTICATION_URI = "/system/workplace/action/authenticate.html";
    private String m_browserBasedAuthenticationMechanism = null;
    private String m_formBasedHttpAuthenticationUri = null;
    private boolean m_useBrowserBasedHttpAuthentication = true;

    public String getBrowserBasedAuthenticationMechanism() {
        if (this.m_useBrowserBasedHttpAuthentication) {
            return AUTHENTICATION_BASIC;
        }
        if (this.m_browserBasedAuthenticationMechanism != null) {
            return this.m_browserBasedAuthenticationMechanism;
        }
        if (this.m_formBasedHttpAuthenticationUri != null) {
            return AUTHENTICATION_FORM;
        }
        return null;
    }

    public String getConfigBrowserBasedAuthentication() {
        if (this.m_useBrowserBasedHttpAuthentication) {
            return Boolean.TRUE.toString();
        }
        if (this.m_browserBasedAuthenticationMechanism != null) {
            return this.m_browserBasedAuthenticationMechanism;
        }
        return Boolean.FALSE.toString();
    }

    public String getFormBasedHttpAuthenticationUri() {
        return this.m_formBasedHttpAuthenticationUri;
    }

    public void setFormBasedHttpAuthenticationUri(String uri) {
        this.m_formBasedHttpAuthenticationUri = uri;
    }

    public void setUseBrowserBasedHttpAuthentication(boolean value) {
        this.m_useBrowserBasedHttpAuthentication = value;
        this.m_browserBasedAuthenticationMechanism = null;
    }

    public void setUseBrowserBasedHttpAuthentication(String value) {
        this.m_useBrowserBasedHttpAuthentication = Boolean.valueOf(value);
        if (!this.m_useBrowserBasedHttpAuthentication && !value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            if (value.equalsIgnoreCase(AUTHENTICATION_BASIC)) {
                this.m_useBrowserBasedHttpAuthentication = true;
            } else {
                this.m_browserBasedAuthenticationMechanism = value;
                this.m_useBrowserBasedHttpAuthentication = false;
            }
        }
    }

    public boolean useBrowserBasedHttpAuthentication() {
        return this.m_useBrowserBasedHttpAuthentication;
    }
}

