/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CmsExportExpiresFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrappedResponse = new ResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
    }

    public void init(FilterConfig filterConfig) {
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setContentType(String type) {
            super.setContentType(type);
            Duration day = Duration.of(1L, ChronoUnit.DAYS);
            Duration year = Duration.of(365L, ChronoUnit.DAYS);
            Duration duration = null;
            if (type != null) {
                duration = type.contains("application/javascript") || type.contains("text/css") || type.contains("text/javascript") ? day : year;
                this.setDateHeader("Expires", System.currentTimeMillis() + duration.toMillis());
                this.setHeader("Cache-Control", "max-age=" + duration.getSeconds());
            }
        }
    }
}

