/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsExportContentTypeFilter
implements Filter {
    private static final Log LOG = CmsLog.getLog(CmsExportContentTypeFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String mimeType;
        if (request instanceof HttpServletRequest && (mimeType = this.getMimeType(httpRequest = (HttpServletRequest)request)) != null) {
            response.setContentType(mimeType);
        }
        chain.doFilter(request, response);
    }

    private String getMimeType(HttpServletRequest httpRequest) {
        try {
            URI uri = new URI(httpRequest.getRequestURI());
            String path = uri.getPath();
            if (!path.endsWith("/")) {
                int slashPos = path.lastIndexOf(47);
                String filename = "";
                filename = slashPos == -1 ? path : path.substring(slashPos + 1);
                String mimeType = OpenCms.getResourceManager().getMimeType(filename, OpenCms.getSystemInfo().getDefaultEncoding(), null);
                return mimeType;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

