/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsMultiException;
import org.opencms.main.I_CmsThrowable;
import org.opencms.util.CmsStringUtil;

public class CmsException
extends Exception
implements I_CmsThrowable {
    private static final long serialVersionUID = -1372556209321406104L;
    protected CmsMessageContainer m_message;

    public CmsException(CmsMessageContainer message) {
        super(message.getKey());
        this.m_message = message;
    }

    public CmsException(CmsMessageContainer message, Throwable cause) {
        super(message.getKey(), cause);
        this.m_message = message;
    }

    public static String getFormattedErrorstack(Throwable t) {
        String stacktrace = CmsException.getStackTraceAsString(t);
        if (CmsStringUtil.isEmpty(stacktrace)) {
            return "";
        }
        stacktrace = CmsStringUtil.escapeJavaScript(stacktrace);
        stacktrace = CmsEncoder.escapeXml(stacktrace);
        StringBuffer result = new StringBuffer(256);
        result.append("<html><body style='background-color: /*begin-color Window*/#ffffff/*end-color*/; overflow: scroll;'><pre>");
        result.append(stacktrace);
        result.append("</pre></body></html>");
        return result.toString();
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        if (e instanceof CmsMultiException) {
            CmsMultiException me = (CmsMultiException)e;
            for (Throwable throwable : me.getExceptions()) {
                throwable.printStackTrace(printWriter);
            }
        }
        return stringWriter.toString();
    }

    public CmsException createException(CmsMessageContainer container, Throwable cause) {
        return new CmsException(container, cause);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.m_message == null) {
            return super.getLocalizedMessage();
        }
        return this.m_message.key();
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.m_message.key(locale);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    @Override
    public CmsMessageContainer getMessageContainer() {
        return this.m_message;
    }
}

