/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import javax.mail.AuthenticationFailedException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.CmsMailUtil;
import org.opencms.mail.Messages;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;

public class CmsSimpleMail
extends SimpleEmail {
    public CmsSimpleMail() {
        this(OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost());
    }

    public CmsSimpleMail(CmsMailHost mailHost) {
        CmsMailUtil.configureMail(mailHost, (Email)this);
    }

    public String send() {
        String messageID = null;
        try {
            messageID = super.send();
        }
        catch (EmailException e) {
            if (e.getCause() instanceof AuthenticationFailedException) {
                CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
                CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_AUTHENTICATE_2", host.getUsername(), host.getHostname()));
                rte.initCause(e);
                throw rte;
            }
            CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_CONFIG_0"));
            rte.initCause(e);
            throw rte;
        }
        return messageID;
    }
}

