/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.json.JSONTokener;
import org.opencms.loader.CmsJsonMessageContainer;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsTransformerTemplateProvider
implements I_CmsTemplateContextProvider {
    private static final String VERSION = "2";
    public static final String COOKIE_PREFIX = "templatetransformer_override_";
    public static final String PARAM_CONFIG = "config";
    public static final String TEMPLATE_KEY_SOURCE = "source";
    public static final String TEMPLATE_KEY_TARGET = "target";
    private static final Log LOG = CmsLog.getLog(CmsTransformerTemplateProvider.class);
    private static Supplier<CmsVfsMemoryObjectCache> m_configCacheProvider = Suppliers.memoize(() -> new CmsVfsMemoryObjectCache());
    private CmsObject m_cms;
    private String m_configPath;
    private String m_cookieName;

    @Override
    public Map<String, CmsTemplateContext> getAllContexts() {
        return this.getConfiguration().getContextMap();
    }

    public Configuration getConfiguration() {
        Configuration config = (Configuration)((CmsVfsMemoryObjectCache)m_configCacheProvider.get()).getCachedObject(this.m_cms, this.m_configPath);
        if (config != null) {
            return config;
        }
        try {
            config = this.loadConfiguration();
            ((CmsVfsMemoryObjectCache)m_configCacheProvider.get()).putCachedObject(this.m_cms, this.m_configPath, config);
            return config;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new Configuration();
        }
    }

    @Override
    public String getDefaultLabel(Locale locale) {
        Configuration config = this.getConfiguration();
        return config.getContextMap().get(TEMPLATE_KEY_SOURCE).getLocalizedName(locale);
    }

    @Override
    public String getEditorStyleSheet(CmsObject cms, String editedResourcePath) {
        return null;
    }

    @Override
    public Set<CmsUUID> getFunctionsForGallery(CmsObject cms, String templateContext) {
        Configuration config = this.getConfiguration();
        Pattern functionFilter = config.getFunctionFilter(templateContext);
        if (functionFilter == null) {
            return null;
        }
        HashSet<CmsUUID> result = new HashSet<CmsUUID>();
        for (I_CmsFormatterBean formatter : OpenCms.getADEManager().getCachedFormatters(false).getFormatters().values()) {
            if (!(formatter instanceof CmsFunctionFormatterBean) || !CmsUUID.isValidUUID(formatter.getId()) || formatter.getLocation() == null || !functionFilter.matcher(formatter.getLocation()).matches()) continue;
            result.add(new CmsUUID(formatter.getId()));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public String getMenuLabel(Locale locale) {
        CmsJsonMessageContainer container = this.getConfiguration().getMenuLabel();
        if (container != null) {
            return container.key(locale);
        }
        return null;
    }

    @Override
    public int getMenuPosition() {
        return 1;
    }

    @Override
    public String getOverrideCookieName() {
        return this.m_cookieName;
    }

    @Override
    public String getTemplateCompatibility(String currentContext) {
        return this.getConfiguration().getTemplateCompatibility(currentContext);
    }

    @Override
    public CmsTemplateContext getTemplateContext(CmsObject cms, HttpServletRequest request, CmsResource resource) {
        Configuration config = this.getConfiguration();
        return config.getContextMap().get(TEMPLATE_KEY_SOURCE);
    }

    @Override
    public void initialize(CmsObject cms, String config) {
        this.m_cms = cms;
        if (config == null) {
            config = "";
        }
        config = config.trim();
        Map<String, String> parsedConfig = CmsStringUtil.splitAsMap(config, ",", "=");
        this.m_configPath = parsedConfig.get(PARAM_CONFIG);
        if (this.m_configPath == null) {
            throw new RuntimeException("Missing parameter 'config' for template provider '" + this.getClass().getName() + "'");
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(this.m_configPath.getBytes(StandardCharsets.UTF_8));
            md5.update((byte)0);
            md5.update(VERSION.getBytes(StandardCharsets.UTF_8));
            byte[] md5bytes = md5.digest();
            this.m_cookieName = COOKIE_PREFIX + Hex.encodeHexString((byte[])md5bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isHiddenContext(String key) {
        return TEMPLATE_KEY_SOURCE.equals(key);
    }

    @Override
    public boolean isIgnoreTemplateContextsSetting() {
        return true;
    }

    @Override
    public String readCommonProperty(CmsObject cms, String propertyName, String fallbackValue) {
        Configuration config = this.getConfiguration();
        try {
            CmsProperty prop = cms.readPropertyObject(config.getContextMap().get(TEMPLATE_KEY_SOURCE).getTemplatePath(), propertyName, false);
            return prop.getValue();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean shouldShowContextMenuOption(CmsObject cms) {
        return OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER);
    }

    @Override
    public boolean shouldShowElementTemplateContextSelection(CmsObject cms) {
        return false;
    }

    protected Configuration loadConfiguration() throws Exception {
        CmsFile configFile = this.m_cms.readFile(this.m_configPath);
        String configStr = new String(configFile.getContents(), StandardCharsets.UTF_8);
        JSONTokener tok = new JSONTokener(configStr);
        tok.setOrdered(true);
        JSONObject configJson = new JSONObject(tok, true);
        return new Configuration(configJson);
    }

    public class Configuration {
        private Map<String, CmsTemplateContext> m_contextMap = new HashMap<String, CmsTemplateContext>();
        private Map<String, Pattern> m_functionFilters = new HashMap<String, Pattern>();
        private CmsJsonMessageContainer m_menuLabel;
        private Map<String, String> m_templateCompatibility = new HashMap<String, String>();

        public Configuration() {
        }

        public Configuration(JSONObject configJson) throws JSONException {
            LinkedHashMap<String, CmsTemplateContext> contextMap = new LinkedHashMap<String, CmsTemplateContext>();
            JSONObject source = configJson.getJSONObject(JsonKeys.sourceTemplate.name());
            JSONObject target = configJson.getJSONObject(JsonKeys.targetTemplate.name());
            CmsTemplateContext sourceContext = this.parseTemplateContext(CmsTransformerTemplateProvider.TEMPLATE_KEY_SOURCE, source);
            CmsTemplateContext targetContext = this.parseTemplateContext(CmsTransformerTemplateProvider.TEMPLATE_KEY_TARGET, target);
            contextMap.put(CmsTransformerTemplateProvider.TEMPLATE_KEY_SOURCE, sourceContext);
            contextMap.put(CmsTransformerTemplateProvider.TEMPLATE_KEY_TARGET, targetContext);
            this.m_contextMap = Collections.unmodifiableMap(contextMap);
            Object menuLabel = configJson.opt(JsonKeys.menuLabel.name());
            if (menuLabel != null) {
                this.m_menuLabel = new CmsJsonMessageContainer(menuLabel);
            }
        }

        public Map<String, CmsTemplateContext> getContextMap() {
            return this.m_contextMap;
        }

        public Pattern getFunctionFilter(String key) {
            return this.m_functionFilters.get(key);
        }

        public CmsJsonMessageContainer getMenuLabel() {
            return this.m_menuLabel;
        }

        public String getTemplateCompatibility(String currentContext) {
            return this.m_templateCompatibility.get(currentContext);
        }

        private CmsTemplateContext parseTemplateContext(String key, JSONObject object) throws JSONException {
            String templateCompatibility;
            Object niceNameValue = object.opt(JsonKeys.niceName.name());
            CmsTemplateContext context = new CmsTemplateContext(key, object.getString(JsonKeys.path.name()), niceNameValue != null ? new CmsJsonMessageContainer(niceNameValue) : null, CmsTransformerTemplateProvider.this, Collections.emptyList(), false);
            String functionFilter = object.optString(JsonKeys.functionFilter.name(), null);
            if (functionFilter != null) {
                this.m_functionFilters.put(key, Pattern.compile(functionFilter));
            }
            if ((templateCompatibility = object.optString(JsonKeys.compatibility.name(), null)) != null) {
                this.m_templateCompatibility.put(key, templateCompatibility);
            }
            return context;
        }
    }

    static enum JsonKeys {
        compatibility,
        functionFilter,
        menuLabel,
        niceName,
        path,
        sourceTemplate,
        targetTemplate;

    }
}

