/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.shared.CmsClientVariantInfo;
import org.opencms.gwt.shared.CmsTemplateContextInfo;
import org.opencms.loader.A_CmsXmlDocumentLoader;
import org.opencms.loader.CmsClientVariant;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsDefaultSet;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsTemplateContextManager {
    public static final String ATTR_RPC_CONTEXT_OVERRIDE = "ATTR_RPC_CONTEXT_OVERRIDE";
    public static final String ATTR_TEMPLATE_BEAN = "ATTR_TEMPLATE_BEAN";
    public static final String ATTR_TEMPLATE_CONTEXT = "templateContext";
    public static final String ATTR_TEMPLATE_NAME = "cmsTemplateName";
    public static final String ATTR_TEMPLATE_RESOURCE = "cmsTemplateResource";
    public static final String DYNAMIC_TEMPLATE_PREFIX = "provider=";
    private static final String DYNAMIC_TEMPLATE_LEGACY_PREFIX = "dynamic:";
    private static final Log LOG = CmsLog.getLog(CmsTemplateContextManager.class);
    private volatile Map<String, CmsDefaultSet<String>> m_cachedContextMap = null;
    private CmsObject m_cms;
    private Map<String, I_CmsTemplateContextProvider> m_providerInstances = new ConcurrentHashMap<String, I_CmsTemplateContextProvider>();

    public CmsTemplateContextManager(CmsObject cms) {
        this.m_cms = cms;
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_RESOURCE);
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_CONTEXT);
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_RESOURCE);
        OpenCms.getExecutor().scheduleWithFixedDelay(this::updateContextMap, 1L, 15L, TimeUnit.SECONDS);
    }

    public static boolean hasPropertyPrefix(String propertyValue) {
        return propertyValue != null && (propertyValue.startsWith(DYNAMIC_TEMPLATE_PREFIX) || propertyValue.startsWith(DYNAMIC_TEMPLATE_LEGACY_PREFIX));
    }

    public static boolean isProvider(String templatePath) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(templatePath)) {
            return false;
        }
        return (templatePath = templatePath.trim()).startsWith(DYNAMIC_TEMPLATE_LEGACY_PREFIX) || templatePath.startsWith(DYNAMIC_TEMPLATE_PREFIX);
    }

    public static String removePropertyPrefix(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.startsWith(DYNAMIC_TEMPLATE_PREFIX)) {
            return propertyValue.substring(DYNAMIC_TEMPLATE_PREFIX.length());
        }
        if (propertyValue.startsWith(DYNAMIC_TEMPLATE_LEGACY_PREFIX)) {
            return propertyValue.substring(DYNAMIC_TEMPLATE_LEGACY_PREFIX.length());
        }
        return propertyValue;
    }

    public CmsTemplateContextInfo getContextInfoBean(CmsObject cms, HttpServletRequest request) {
        CmsTemplateContextInfo result = new CmsTemplateContextInfo();
        CmsTemplateContext context = (CmsTemplateContext)request.getAttribute(ATTR_TEMPLATE_CONTEXT);
        if (context != null) {
            result.setCurrentContext(context.getKey());
            I_CmsTemplateContextProvider provider = context.getProvider();
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            result.setMenuLabel(provider.getMenuLabel(locale));
            result.setDefaultLabel(provider.getDefaultLabel(locale));
            result.setShouldShowElementTemplateContextSelection(provider.shouldShowElementTemplateContextSelection(cms));
            CmsXmlContentProperty settingDefinition = this.createTemplateContextsPropertyDefinition(provider, locale);
            result.setSettingDefinition(settingDefinition);
            String cookieName = context.getProvider().getOverrideCookieName();
            if (cookieName != null) {
                String cookieValue = CmsRequestUtil.getCookieValue(request.getCookies(), cookieName);
                result.setSelectedContext(cookieValue);
            }
            result.setCookieName(cookieName);
            LinkedHashMap<String, String> niceNames = new LinkedHashMap<String, String>();
            for (Map.Entry<String, CmsTemplateContext> entry : provider.getAllContexts().entrySet()) {
                CmsTemplateContext otherContext = entry.getValue();
                if (provider.isHiddenContext(otherContext.getKey())) continue;
                String niceName = otherContext.getLocalizedName(locale);
                niceNames.put(otherContext.getKey(), niceName);
                for (CmsClientVariant variant : otherContext.getClientVariants().values()) {
                    CmsClientVariantInfo info = new CmsClientVariantInfo(variant.getName(), variant.getNiceName(locale), variant.getScreenWidth(), variant.getScreenHeight(), variant.getParameters());
                    result.setClientVariant(otherContext.getKey(), variant.getName(), info);
                }
            }
            result.setContextLabels(niceNames);
            String providerKey = OpenCms.getTemplateContextManager().getProviderKey(provider);
            result.setContextProvider(providerKey);
        }
        Map<String, CmsDefaultSet<String>> allowedContextMap = this.safeGetAllowedContextMap();
        result.setAllowedContexts(allowedContextMap);
        return result;
    }

    public String getProviderKey(I_CmsTemplateContextProvider provider) {
        for (Map.Entry<String, I_CmsTemplateContextProvider> entry : this.m_providerInstances.entrySet()) {
            if (entry.getValue() != provider) continue;
            return entry.getKey();
        }
        return null;
    }

    public CmsTemplateContext getTemplateContext(String providerName, CmsObject cms, HttpServletRequest request, CmsResource resource) {
        Map<String, CmsTemplateContext> contextMap;
        I_CmsTemplateContextProvider provider = this.getTemplateContextProvider(providerName);
        if (provider == null) {
            return null;
        }
        String cookieName = provider.getOverrideCookieName();
        String forcedValue = null;
        if (request != null) {
            String paramTemplateContext = request.getParameter("__templateContext");
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(paramTemplateContext)) {
                forcedValue = paramTemplateContext;
            } else if (cookieName != null) {
                forcedValue = CmsRequestUtil.getCookieValue(request.getCookies(), cookieName);
            }
        }
        if (forcedValue != null && (contextMap = provider.getAllContexts()).containsKey(forcedValue)) {
            CmsTemplateContext contextBean = contextMap.get(forcedValue);
            return new CmsTemplateContext(contextBean.getKey(), contextBean.getTemplatePath(), contextBean.getMessageContainer(), contextBean.getProvider(), contextBean.getClientVariants().values(), true);
        }
        return provider.getTemplateContext(cms, request, resource);
    }

    public I_CmsTemplateContextProvider getTemplateContextProvider(CmsObject cms, String path) throws CmsException {
        CmsResource resource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(resource);
        if (loader instanceof A_CmsXmlDocumentLoader) {
            String propertyValue;
            List<CmsProperty> properties;
            String propertyName = ((A_CmsXmlDocumentLoader)loader).getTemplatePropertyDefinition();
            CmsProperty property = CmsProperty.get(propertyName, properties = cms.readPropertyObjects(resource, true));
            if (property != null && !property.isNullProperty() && CmsTemplateContextManager.hasPropertyPrefix(propertyValue = property.getValue())) {
                return this.getTemplateContextProvider(CmsTemplateContextManager.removePropertyPrefix(propertyValue));
            }
            return null;
        }
        return null;
    }

    public I_CmsTemplateContextProvider getTemplateContextProvider(String providerName) {
        I_CmsTemplateContextProvider result;
        if (providerName == null) {
            return null;
        }
        providerName = providerName.trim();
        String providerClassName = providerName = CmsTemplateContextManager.removePropertyPrefix(providerName);
        String providerConfig = "";
        int separatorIndex = providerName.indexOf(",");
        if (separatorIndex > 0) {
            providerClassName = providerName.substring(0, separatorIndex);
            providerConfig = providerName.substring(separatorIndex + 1);
        }
        if ((result = this.m_providerInstances.get(providerName)) == null) {
            try {
                Class<?> providerClass = Class.forName(providerClassName, false, this.getClass().getClassLoader());
                if (I_CmsTemplateContextProvider.class.isAssignableFrom(providerClass)) {
                    result = (I_CmsTemplateContextProvider)providerClass.newInstance();
                    result.initialize(this.m_cms, providerConfig);
                    this.m_providerInstances.put(providerName, result);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
        }
        return result;
    }

    public String readPropertyFromTemplate(CmsObject cms, CmsResource res, String propertyName, String fallbackValue) {
        try {
            CmsProperty templateProp = cms.readPropertyObject(res, "template", true);
            String templatePath = templateProp.getValue().trim();
            if (CmsTemplateContextManager.hasPropertyPrefix(templatePath)) {
                I_CmsTemplateContextProvider provider = this.getTemplateContextProvider(templatePath);
                return provider.readCommonProperty(cms, propertyName, fallbackValue);
            }
            return cms.readPropertyObject(templatePath, propertyName, false).getValue(fallbackValue);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return fallbackValue;
        }
    }

    public boolean shouldShowType(String contextKey, String typeName) {
        Map<String, CmsDefaultSet<String>> allowedContextMap = this.safeGetAllowedContextMap();
        CmsDefaultSet<String> allowedContexts = allowedContextMap.get(typeName);
        if (allowedContexts == null) {
            return true;
        }
        return allowedContexts.contains(contextKey);
    }

    protected CmsXmlContentProperty createTemplateContextsPropertyDefinition(I_CmsTemplateContextProvider contextProvider, Locale locale) {
        if (contextProvider == null) {
            return null;
        }
        ArrayList<CallSite> contextOptions = new ArrayList<CallSite>();
        for (CmsTemplateContext context : contextProvider.getAllContexts().values()) {
            contextOptions.add((CallSite)((Object)(context.getKey() + ":" + context.getLocalizedName(locale))));
        }
        String widgetConfig = CmsStringUtil.listAsString(contextOptions, "|");
        String niceName = Messages.get().getBundle(locale).key("GUI_SETTING_TEMPLATE_CONTEXTS_NAME_0");
        String description = Messages.get().getBundle(locale).key("GUI_SETTING_TEMPLATE_CONTEXTS_DESCRIPTION_0");
        CmsXmlContentProperty propDef = new CmsXmlContentProperty("templateContexts", "string", "multicheck", widgetConfig, null, null, "", niceName, description, "", "false");
        return propDef;
    }

    protected Map<String, CmsDefaultSet<String>> safeGetAllowedContextMap() {
        Map<String, CmsDefaultSet<String>> result = this.m_cachedContextMap;
        if (result != null) {
            return result;
        }
        try {
            return OpenCms.getResourceManager().getAllowedContextMap(this.m_cms);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    void updateContextMap() {
        try {
            LOG.debug((Object)"Updating cached 'allowed template contexts' map.");
            this.m_cachedContextMap = OpenCms.getResourceManager().getAllowedContextMap(this.m_cms);
            LOG.debug((Object)"Finished updating cached 'allowed template contexts' map.");
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

