/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.loader.I_CmsFlexCacheEnabledLoader;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;

public class CmsRedirectLoader
implements I_CmsResourceLoader,
I_CmsFlexCacheEnabledLoader {
    public static final int LOADER_ID = 13;
    private static final CmsParameterConfiguration CONFIG = new CmsParameterConfiguration();
    private CmsFlexCache m_cache;

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        return cms.readFile(resource).getContents();
    }

    @Override
    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) {
        throw new CmsRuntimeException(Messages.get().container("ERR_EXPORT_UNSUPPORTED_1", this.getClass().getName()));
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return CONFIG;
    }

    @Override
    public int getLoaderId() {
        return 13;
    }

    @Override
    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_HTMLREDIRECT_DEFAULT_DESC_0");
    }

    @Override
    public void initConfiguration() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean isStaticExportEnabled() {
        return false;
    }

    @Override
    public boolean isStaticExportProcessable() {
        return false;
    }

    @Override
    public boolean isUsableForTemplates() {
        return false;
    }

    @Override
    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        this.getController(cms, resource, req, res, false, true);
        OpenCms.getADEManager().handleHtmlRedirect(cms, req, res, cms.getSitePath(resource));
        CmsFlexController.removeController((ServletRequest)req);
    }

    @Override
    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) {
        throw new CmsRuntimeException(Messages.get().container("ERR_SERVICE_UNSUPPORTED_1", this.getClass().getName()));
    }

    @Override
    public void setFlexCache(CmsFlexCache cache) {
        this.m_cache = cache;
    }

    protected CmsFlexController getController(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res, boolean streaming, boolean top) {
        CmsFlexController controller = null;
        if (top) {
            controller = CmsFlexController.getController((ServletRequest)req);
        }
        if (controller == null) {
            controller = new CmsFlexController(cms, resource, this.m_cache, req, res, streaming, top);
            CmsFlexController.setController((ServletRequest)req, controller);
            CmsFlexRequest f_req = new CmsFlexRequest(req, controller);
            CmsFlexResponse f_res = new CmsFlexResponse(res, controller, streaming, true);
            controller.push(f_req, f_res);
        } else if (controller.isForwardMode()) {
            controller = new CmsFlexController(cms, controller);
            CmsFlexController.setController((ServletRequest)req, controller);
        }
        return controller;
    }
}

