/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkInfo;

public class CmsTemplatePluginWrapper {
    private static final Log LOG = CmsLog.getLog(CmsTemplatePluginWrapper.class);
    private CmsObject m_cms;
    private CmsTemplatePlugin m_plugin;

    public CmsTemplatePluginWrapper(CmsObject cms, CmsTemplatePlugin plugin) {
        this.m_cms = cms;
        this.m_plugin = plugin;
    }

    public Map<String, String> getAttributes() {
        return this.m_plugin.getAttributes();
    }

    public String getGroup() {
        return this.m_plugin.getGroup();
    }

    public String getLink() {
        CmsLinkInfo target = this.m_plugin.getTarget();
        CmsLink targetLink = target.toLink();
        if (targetLink == null) {
            LOG.warn((Object)("getLink called on template plugin with no link target: " + this.toString()));
            return "";
        }
        String link = targetLink.getLink(this.m_cms);
        return link;
    }

    public int getOrder() {
        return this.m_plugin.getOrder();
    }

    public String getPath() {
        CmsLinkInfo target = this.m_plugin.getTarget();
        if (!target.isInternal()) {
            return null;
        }
        CmsLink targetLink = target.toLink();
        if (targetLink == null) {
            return null;
        }
        targetLink.checkConsistency(this.m_cms);
        return this.m_cms.getRequestContext().removeSiteRoot(targetLink.getTarget());
    }

    public CmsTemplatePlugin getPlugin() {
        return this.m_plugin;
    }

    public String toString() {
        return this.m_plugin.toString();
    }
}

