/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.gwt.Messages;
import org.opencms.jsp.util.CmsKeyDummyMacroResolver;
import org.opencms.jsp.util.I_CmsInfoWrapper;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsSettingDefinitionWrapper
implements I_CmsInfoWrapper {
    private static final Log LOG = CmsLog.getLog(CmsSettingDefinitionWrapper.class);
    private CmsObject m_cms;
    private CmsXmlContentProperty m_definitionWithKeys;
    private CmsXmlContentProperty m_rawDefinition;
    private CmsXmlContentProperty m_resolvedDefinition;
    private Map<Locale, CmsXmlContentProperty> m_resolvedDefsByLocale = new HashMap<Locale, CmsXmlContentProperty>();
    private Function<Locale, CmsMacroResolver> m_resolverProvider;

    public CmsSettingDefinitionWrapper(CmsObject cms, CmsXmlContentProperty settingDef, Function<Locale, CmsMacroResolver> resolverProvider) {
        this.m_resolverProvider = resolverProvider;
        this.m_rawDefinition = settingDef;
        this.m_cms = cms;
        this.m_resolvedDefinition = this.resolveDefinition(cms.getRequestContext().getLocale());
        CmsKeyDummyMacroResolver keyResolver = new CmsKeyDummyMacroResolver(resolverProvider.apply(cms.getRequestContext().getLocale()));
        this.m_definitionWithKeys = CmsXmlContentPropertyHelper.resolveMacrosInProperty(settingDef, keyResolver);
    }

    public String getDefaultValue() {
        return this.m_resolvedDefinition.getDefault();
    }

    @Override
    public String getDescription() {
        return this.m_resolvedDefinition.getDescription();
    }

    @Override
    public String getDescription(Locale locale) {
        CmsXmlContentProperty resolvedDef = this.resolveDefinition(locale);
        return resolvedDef.getDescription();
    }

    @Override
    public String getDescriptionKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_definitionWithKeys.getDescription());
    }

    @Override
    public String getDescriptionRaw() {
        return this.m_rawDefinition.getDescription();
    }

    public String getDisplayName() {
        return this.m_resolvedDefinition.getNiceName();
    }

    public String getDisplayNameKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_definitionWithKeys.getNiceName());
    }

    public String getDisplayNameRaw() {
        return this.m_rawDefinition.getNiceName();
    }

    public List<CmsSelectWidgetOption> getParsedSelectOptions() {
        String widgetConfig = this.getWidgetConfig();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(widgetConfig)) {
            return null;
        }
        try {
            List<CmsSelectWidgetOption> options = CmsSelectWidgetOption.parseOptions(widgetConfig);
            ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
            Set values = options.stream().map(option -> option.getValue()).collect(Collectors.toSet());
            String defaultValue = this.getDefaultValue();
            Locale locale = this.m_cms.getRequestContext().getLocale();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(defaultValue) || !values.contains(defaultValue)) {
                CmsSelectWidgetOption noValue = new CmsSelectWidgetOption("", true, Messages.get().getBundle(locale).key("GUI_SELECTBOX_EMPTY_SELECTION_0"));
                result.add(noValue);
            }
            result.addAll(options);
            return result;
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getPropertyName() {
        return this.m_resolvedDefinition.getName();
    }

    public String getVisibility() {
        return String.valueOf((Object)this.m_resolvedDefinition.getVisibility(CmsXmlContentProperty.Visibility.elementAndParentIndividual));
    }

    public String getWidget() {
        return this.m_resolvedDefinition.getWidget();
    }

    public String getWidgetConfig() {
        return this.m_resolvedDefinition.getWidgetConfiguration();
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "???";
        }
    }

    private CmsXmlContentProperty resolveDefinition(Locale locale) {
        return this.m_resolvedDefsByLocale.computeIfAbsent(locale, loc -> {
            CmsMacroResolver resolver = this.m_resolverProvider.apply((Locale)loc);
            return CmsXmlContentPropertyHelper.resolveMacrosInProperty(this.m_rawDefinition, resolver);
        });
    }
}

