/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagDisplay;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsMacroFormatterResolver {
    public static final String KEY_CMS = "cms.";
    public static final String KEY_ELEMENT = "element.";
    public static final String KEY_PARENT = "parent.";
    public static final String KEY_SETTINGS = "settings.";
    public static final String N_FORMATTER = "Formatter";
    public static final String N_FORMATTERS = "Formatters";
    public static final String N_MACRO = "Macro";
    public static final String N_MACRO_NAME = "MacroName";
    private static final Log LOG = CmsLog.getLog(CmsMacroFormatterResolver.class);
    private CmsObject m_cms;
    private PageContext m_context;
    private CmsJspStandardContextBean m_contextBean;
    private CmsContainerElementBean m_element;
    private Map<String, CmsUUID> m_formatterReferences;
    private String m_input;
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;

    public CmsMacroFormatterResolver(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.m_context = context;
        this.m_request = req;
        this.m_response = res;
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        if (controller == null) {
            this.handleMissingFlexController();
            return;
        }
        this.m_cms = controller.getCmsObject();
        this.m_contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)this.m_request);
        this.m_element = this.m_contextBean.getElement();
    }

    public void resolve() throws IOException, CmsException {
        int nextDelimPos;
        int endChar;
        int startChar;
        int delimPos;
        this.initMacroContent();
        String input = this.getMacroInput();
        if (input == null) {
            return;
        }
        if (input.length() < 3) {
            this.m_context.getOut().print(input);
            return;
        }
        int newDelimPos = input.indexOf(37);
        int oldDelomPos = input.indexOf(36);
        if (oldDelomPos == -1 && newDelimPos == -1) {
            this.m_context.getOut().print(input);
            return;
        }
        int len = input.length();
        if (oldDelomPos == -1 || newDelimPos > -1 && newDelimPos < oldDelomPos) {
            delimPos = newDelimPos;
            startChar = 40;
            endChar = 41;
        } else {
            delimPos = oldDelomPos;
            startChar = 123;
            endChar = 125;
        }
        this.m_context.getOut().print(input.substring(0, delimPos));
        do {
            int endPos;
            int delimPos1;
            int delimPos2;
            if ((delimPos2 = (delimPos1 = delimPos + 1) + 1) >= len) {
                this.m_context.getOut().print(input.substring(delimPos, len));
                break;
            }
            if (newDelimPos > -1 && newDelimPos < delimPos1) {
                newDelimPos = input.indexOf(37, delimPos1);
            }
            if (oldDelomPos > -1 && oldDelomPos < delimPos1) {
                oldDelomPos = input.indexOf(36, delimPos1);
            }
            nextDelimPos = oldDelomPos == -1 && newDelimPos == -1 ? len : (oldDelomPos == -1 || newDelimPos > -1 && newDelimPos < oldDelomPos ? newDelimPos : oldDelomPos);
            int start = input.charAt(delimPos1);
            if (start == startChar) {
                endPos = input.indexOf(endChar, delimPos);
                if (endPos > 0 && endPos < nextDelimPos) {
                    String macro = input.substring(delimPos2, endPos);
                    try {
                        this.printMacroValue(macro);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Writing value for macro '" + macro + "' failed."), (Throwable)ex);
                    }
                    ++endPos;
                } else {
                    endPos = delimPos;
                }
            } else {
                endPos = delimPos;
            }
            if (nextDelimPos == newDelimPos) {
                startChar = 40;
                endChar = 41;
            } else {
                startChar = 123;
                endChar = 125;
            }
            this.m_context.getOut().print(input.substring(endPos, nextDelimPos));
        } while ((delimPos = nextDelimPos) < len);
    }

    protected I_CmsFormatterBean getFormatterForMacro(String macro) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.getRequestContext().getRootUri());
        CmsUUID formatterId = null;
        if (this.m_formatterReferences.containsKey(macro)) {
            formatterId = this.m_formatterReferences.get(macro);
        } else {
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType("formatter_config");
                CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(type);
                if (this.m_cms.existsResource(macro, filter)) {
                    CmsResource res = this.m_cms.readResource(macro);
                    formatterId = res.getStructureId();
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Failed to read formatter configuration.", (Throwable)e);
            }
        }
        if (formatterId != null) {
            return config.findFormatter(formatterId);
        }
        return null;
    }

    protected Object getMacroBeanValue(Object bean, String property) {
        Object result = null;
        if (bean != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(property)) {
            try {
                PropertyUtilsBean propBean = BeanUtilsBean.getInstance().getPropertyUtils();
                result = propBean.getProperty(bean, property);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to access property '" + property + "' of '" + String.valueOf(bean) + "'."), (Throwable)e);
            }
        } else {
            LOG.info((Object)("Invalid parameters: property='" + property + "' bean='" + String.valueOf(bean) + "'."));
        }
        return result;
    }

    protected String getMacroInput() {
        return this.m_input;
    }

    protected void printMacroValue(String macro) throws IOException {
        if (macro.startsWith(KEY_CMS)) {
            Object result = this.getMacroBeanValue(this.m_contextBean, macro.substring(KEY_CMS.length()));
            if (result != null) {
                this.m_context.getOut().print(result);
            }
        } else if (macro.startsWith(KEY_ELEMENT)) {
            Object result = this.getMacroBeanValue(this.m_contextBean.getElement(), macro.substring(KEY_ELEMENT.length()));
            if (result != null) {
                this.m_context.getOut().print(result);
            }
        } else if (macro.startsWith(KEY_PARENT)) {
            Object result = this.getMacroBeanValue(this.m_contextBean.getParentElement(this.m_element), macro.substring(KEY_PARENT.length()));
            if (result != null) {
                this.m_context.getOut().print(result);
            }
        } else if (macro.startsWith(KEY_SETTINGS)) {
            String settingValue = this.m_element.getSettings().get(macro.substring(KEY_SETTINGS.length()));
            if (settingValue != null) {
                this.m_context.getOut().print(settingValue);
            }
        } else {
            I_CmsFormatterBean formatter = this.getFormatterForMacro(macro);
            if (formatter != null) {
                CmsContainerElementBean copy = CmsContainerElementBean.cloneWithFormatter(this.m_element, formatter.getJspStructureId());
                copy.setDoNotCache(true);
                try {
                    CmsJspTagDisplay.displayAction(copy, formatter, this.m_context, (ServletRequest)this.m_request, (ServletResponse)this.m_response);
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to display formatted content.", (Throwable)e);
                }
            }
        }
    }

    private void handleMissingFlexController() {
        throw new CmsRuntimeException(Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsMacroFormatterResolver.class.getName()));
    }

    private void initMacroContent() throws CmsException {
        block5: {
            block4: {
                CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.getRequestContext().getRootUri());
                I_CmsFormatterBean formatterConfig = adeConfig.findFormatter(this.m_element.getFormatterId());
                if (!(formatterConfig instanceof CmsMacroFormatterBean)) break block4;
                CmsMacroFormatterBean config = (CmsMacroFormatterBean)formatterConfig;
                this.m_input = config.getMacroInput();
                this.m_formatterReferences = config.getReferencedFormatters();
                if (!this.m_element.isInMemoryOnly()) break block5;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(config.getPlaceholderMacroInput())) {
                    this.m_input = config.getPlaceholderMacroInput();
                }
                if (config.getDefaultContentStructureId() == null) break block5;
                try {
                    CmsResource defaultContent = this.m_cms.readResource(((CmsMacroFormatterBean)formatterConfig).getDefaultContentStructureId());
                    CmsFile defaultFile = this.m_cms.readFile(defaultContent);
                    this.m_element = new CmsContainerElementBean(defaultFile, this.m_element.getFormatterId(), this.m_element.getIndividualSettings(), true, this.m_element.editorHash(), this.m_element.isCreateNew());
                }
                catch (CmsException e) {
                    LOG.error((Object)"Error reading default content for new resource", (Throwable)e);
                }
                break block5;
            }
            this.m_formatterReferences = new HashMap<String, CmsUUID>();
            CmsResource macroContent = this.m_cms.readResource(this.m_element.getFormatterId());
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_cms, macroContent, (ServletRequest)this.m_request);
            this.m_input = xmlContent.getStringValue(this.m_cms, N_MACRO, CmsLocaleManager.MASTER_LOCALE);
            List<I_CmsXmlContentValue> formatters = xmlContent.getValues(N_FORMATTERS, CmsLocaleManager.MASTER_LOCALE);
            for (I_CmsXmlContentValue formatterValue : formatters) {
                CmsXmlVfsFileValue file = (CmsXmlVfsFileValue)xmlContent.getValue(formatterValue.getPath() + "/Formatter", CmsLocaleManager.MASTER_LOCALE);
                String macroName = xmlContent.getStringValue(this.m_cms, formatterValue.getPath() + "/MacroName", CmsLocaleManager.MASTER_LOCALE);
                this.m_formatterReferences.put(macroName, file.getLink(this.m_cms).getStructureId());
            }
        }
    }
}

