/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsKeyDummyMacroResolver
extends CmsMacroResolver {
    public static final Pattern PATTERN_MESSAGE = Pattern.compile("^%\\(key\\.([^\\)]++)\\)$");
    public static final Pattern PATTERN_MESSAGE_UNANCHORED = Pattern.compile("%\\(key\\.([^\\)]++)\\)\\s*");
    private static final Log LOG = CmsLog.getLog(CmsKeyDummyMacroResolver.class);
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    private CmsMacroResolver m_delegate;
    private Map<CmsUUID, String> m_keys = new HashMap<CmsUUID, String>();

    public CmsKeyDummyMacroResolver(CmsMacroResolver delegate) {
        this.m_delegate = delegate;
    }

    public static String getKey(String s) {
        if (s == null) {
            return null;
        }
        Matcher matcher = PATTERN_MESSAGE.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getKey(String s, CmsMacroResolver delegate) {
        List<String> keys = CmsKeyDummyMacroResolver.getKeys(s, delegate);
        if (keys != null && keys.size() > 0) {
            return keys.get(0);
        }
        return null;
    }

    public static List<String> getKeys(String s, CmsMacroResolver delegate) {
        if (s == null) {
            return null;
        }
        CmsKeyDummyMacroResolver resolver = new CmsKeyDummyMacroResolver(delegate);
        String resolved = resolver.resolveMacros(s);
        return CmsKeyDummyMacroResolver.parseKeys(resolved);
    }

    public static List<String> parseKeys(String s) {
        if (s == null) {
            LOG.debug((Object)("Not a sequence of key macros: [" + s + "]"));
            return null;
        }
        s = s.trim();
        Matcher matcher = PATTERN_MESSAGE_UNANCHORED.matcher(s);
        int offset = 0;
        ArrayList<String> keys = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.start() != offset) {
                LOG.debug((Object)("Not a sequence of key macros: [" + s + "]"));
                return null;
            }
            keys.add(matcher.group(1));
            offset = matcher.end();
        }
        if (offset != s.length()) {
            LOG.debug((Object)("Not a sequence of key macros: [" + s + "]"));
            return null;
        }
        return keys;
    }

    @Override
    public String getMacroValue(String macro) {
        if (macro.startsWith("key.")) {
            String key = macro.substring("key.".length());
            CmsUUID id = new CmsUUID();
            this.m_keys.put(id, key);
            return id.toString();
        }
        String result = this.m_delegate.getMacroValue(macro);
        return result;
    }

    @Override
    public String resolveMacros(String input) {
        String processedInput = super.resolveMacros(input);
        String result = CmsStringUtil.substitute(UUID_PATTERN, processedInput, (s, matcher) -> {
            CmsUUID id = new CmsUUID(matcher.group());
            if (this.m_keys.containsKey(id)) {
                return "%(key." + this.m_keys.get(id) + ")";
            }
            return matcher.group();
        });
        return result;
    }
}

