/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public final class CmsJspObjectValueWrapper
extends A_CmsJspValueWrapper {
    private static final Log LOG = CmsLog.getLog(CmsJspObjectValueWrapper.class);
    protected static final CmsJspObjectValueWrapper NULL_VALUE_WRAPPER = new CmsJspObjectValueWrapper();
    private int m_hashCode;
    private Object m_object;

    private CmsJspObjectValueWrapper() {
        this(null, null);
    }

    private CmsJspObjectValueWrapper(CmsObject cms, Object value) {
        this.m_cms = cms;
        this.m_object = value;
    }

    public static CmsJspObjectValueWrapper createWrapper(CmsObject cms, Object value) {
        if (value != null && cms != null) {
            return new CmsJspObjectValueWrapper(cms, value);
        }
        return NULL_VALUE_WRAPPER;
    }

    static boolean isDirectEditEnabled(CmsObject cms) {
        return !cms.getRequestContext().getCurrentProject().isOnlineProject() && cms.getRequestContext().getAttribute("__disableDirectEdit") == null;
    }

    @Override
    public boolean getExists() {
        return this.m_object != null;
    }

    @Override
    public boolean getIsEmpty() {
        if (this.m_object == null) {
            return true;
        }
        if (this.m_object instanceof String) {
            return CmsStringUtil.isEmpty((String)this.m_object);
        }
        if (this.m_object instanceof Collection) {
            return !((Collection)this.m_object).isEmpty();
        }
        return false;
    }

    @Override
    public boolean getIsEmptyOrWhitespaceOnly() {
        if (this.m_object instanceof String) {
            return CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_object);
        }
        return this.getIsEmpty();
    }

    @Override
    public Object getObjectValue() {
        return this.m_object;
    }

    @Override
    public Date getToDate() {
        if (this.m_object instanceof Date) {
            return (Date)this.m_object;
        }
        return super.getToDate();
    }

    @Override
    public CmsJspResourceWrapper getToResource() {
        try {
            return CmsJspElFunctions.convertResource(this.m_cms, this.m_object);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Failed to convert object \"" + this.getToString() + "\" to a resource."), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public int hashCode() {
        if (this.m_object == null) {
            return 0;
        }
        if (this.m_hashCode == 0) {
            this.m_hashCode = this.m_object.toString().hashCode();
        }
        return this.m_hashCode;
    }

    @Override
    public String toString() {
        if (this.m_object == null) {
            return "";
        }
        return this.m_object.toString();
    }
}

